/*
 * Copyright 2019 Jefferson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.jefferson.sdk;


import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;

import org.java_websocket.client.WebSocketClient;
import org.json.JSONObject;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;

import static pro.jefferson.sdk.ServerConnection.apikey;

public class ThreadWatcher implements LocationListener {
    public static Location location;
    public static JSONObject jo;

    public static void Watch(final WebSocketClient wsc) {

        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler() {
            @Override
            public void uncaughtException(Thread thread, final Throwable throwable) {


                new Thread() {
                    public void run() {


                        try {
                            jo = new JSONObject();
                            try {
                                jo.put("Location", location.getLatitude() + "," + location.getLongitude());
                            } catch (Exception eee) {
                            }
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            throwable.printStackTrace(pw);
                            jo.put("GeoVisionUser", Jefferson.getGeovisionUserForCrashLog());
                            jo.put("DeviceID", new Utils().getDeviceID());
                            jo.put("ApiKey", apikey);
                            jo.put("DeviceDetails", new Utils().devicedetails(Jefferson.c));
                            jo.put("Payload", sw.toString());
                            jo.put("ReportDate", System.currentTimeMillis());
                        } catch (Exception asdf) {
                            //corrupted data
                        }

                        try {
                            if (wsc.isOpen())
                                wsc.send(jo.toString());
                            else
                                wsc.connectBlocking();
                                wsc.send(jo.toString());
                        } catch (Exception e) {
                            //save to file
                            writeToFile(jo);
                        }
                        System.exit(9);

                    }
                }.run();
                //save to local db.
                //send it immediateley


            }
        });

    }


    public static void writeToFile(JSONObject jo){
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(Jefferson.c.openFileOutput(System.currentTimeMillis() + "-JFlog.txt", Context.MODE_PRIVATE));
            outputStreamWriter.write(jo.toString());
            outputStreamWriter.close();
        } catch (IOException e3) {
            Log.e("Exception", "File write failed: " + e3.toString());
        }

    }

    public void startLocationListener(Context c) throws SecurityException {

        LocationManager locationManager = (LocationManager) c.getSystemService(Context.LOCATION_SERVICE);
        locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 0, 0, this);

    }

    @Override
    public void onLocationChanged(Location location) {
        this.location = location;
    }

    @Override
    public void onStatusChanged(String s, int i, Bundle bundle) {

    }

    @Override
    public void onProviderEnabled(String s) {

    }

    @Override
    public void onProviderDisabled(String s) {

    }
}
