/*
 * Copyright 2019 Jefferson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.jefferson.sdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;

public class CheckApiKey {
    Context c;
    String apikey;

    public CheckApiKey(Context c) {
        this.c = c;
    }

    public String docheck() {
        try {
            ApplicationInfo ai = this.c.getPackageManager().getApplicationInfo(this.c.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = ai.metaData;
            apikey = bundle.getString("JEFFERSON_API_KEY");
            return apikey;
        } catch (Exception a) {
            System.out.println("dummy apikey_not_found: " + "Please add your api key meta tag to your MANIFEST file. See More http://jefferson.pro/setupSDK");
            return null;
        }

    }
}
