/*
 * Decompiled with CFR 0.152.
 */
package pro.johndunlap.getopt;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import pro.johndunlap.getopt.ExitMechanism;
import pro.johndunlap.getopt.OptionInfo;
import pro.johndunlap.getopt.ParseContext;
import pro.johndunlap.getopt.Parser;
import pro.johndunlap.getopt.ReflectionUtil;
import pro.johndunlap.getopt.TypeConverter;
import pro.johndunlap.getopt.annotation.GetOptOrdered;
import pro.johndunlap.getopt.annotation.Help;
import pro.johndunlap.getopt.annotation.Ignore;
import pro.johndunlap.getopt.exception.ParseException;

public class GetOpt {
    private ExitMechanism exitMechanism = System::exit;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private final Map<Class<?>, TypeConverter<?>> typeConverters = new HashMap();

    public GetOpt register(Class<?> type, TypeConverter<?> typeConverter) {
        this.typeConverters.put(type, typeConverter);
        return this;
    }

    public GetOpt register(Map<Class<?>, TypeConverter<?>> typeConverters) {
        this.typeConverters.putAll(typeConverters);
        return this;
    }

    public <T> T read(Class<T> classType, String[] args) throws ParseException {
        return this.readContext(classType, args).getInstance();
    }

    public <T> ParseContext<T> readContext(Class<T> classType, String[] args) throws ParseException {
        ParseContext<T> context = new ParseContext<T>(classType, args, this.typeConverters);
        for (Parser state = Parser.NEUTRAL; state != null; state = state.execute(context)) {
        }
        T instance = context.getInstance();
        if (!context.isHelpRequested()) {
            for (Field field : context.getRequiredFields()) {
                try {
                    Object value = ReflectionUtil.getFieldValue(field, instance);
                    if (value != null) continue;
                    throw new ParseException(field, "Required argument --" + Parser.camelCaseToHyphenCase(field.getName()) + " is not set");
                }
                catch (IllegalAccessException e) {
                    throw new ParseException("Could not access field " + field.getName(), e);
                }
            }
        }
        return context;
    }

    protected <T> void showHelp(Class<T> classType) {
        this.out.println(this.help(classType));
        this.exitMechanism.exit(0);
    }

    public <T> T run(Class<T> classType, String[] args) {
        T instance = null;
        try {
            ParseContext<T> context = this.readContext(classType, args);
            if (context.isHelpRequested()) {
                this.showHelp(classType);
            } else {
                instance = context.getInstance();
            }
            return instance;
        }
        catch (ParseException e) {
            this.getErr().println(e.getMessage());
            this.exitMechanism.exit(e.getExitStatus());
            return instance;
        }
    }

    public <T> String help(Class<T> classType) {
        Help help = classType.getAnnotation(Help.class);
        StringBuilder sb = new StringBuilder();
        String before = "";
        String after = "";
        if (help != null) {
            before = help.openingText();
            after = help.closingText();
        } else {
            before = "The following options are accepted: ";
        }
        sb.append(before);
        HashMap categorized = new HashMap();
        int longestLongName = 0;
        HashMap<String, Boolean> categoryMap = new HashMap<String, Boolean>();
        for (OptionInfo optionInfo : this.extract(classType)) {
            List<OptionInfo> list;
            String category = optionInfo.getCategory();
            if (category.equals("")) {
                category = "default";
            } else {
                categoryMap.put(category, true);
            }
            if (!categorized.containsKey(category)) {
                list = new ArrayList();
                categorized.put(category, list);
            } else {
                list = (List)categorized.get(category);
            }
            list.add(optionInfo);
            int length = optionInfo.getFlag().length();
            if (length <= longestLongName) continue;
            longestLongName = length;
        }
        LinkedList categoryList = new LinkedList(categoryMap.keySet());
        Collections.sort(categoryList);
        categoryList.addFirst("default");
        String longestWhitespace = String.join((CharSequence)"", Collections.nCopies(longestLongName, " "));
        for (String category : categoryList) {
            List namedOptionList = (List)categorized.get(category);
            if (!category.equals("default")) {
                sb.append("\n\n").append(category).append(":");
            }
            for (OptionInfo nameOption : namedOptionList) {
                sb.append("\n  ");
                if (nameOption.getCode() != ' ') {
                    sb.append('-').append(nameOption.getCode());
                } else {
                    sb.append(' ');
                }
                String longName = nameOption.getFlag();
                if (longName.equals("")) {
                    sb.append(longestWhitespace);
                } else {
                    sb.append("  --").append(longName).append(longestWhitespace, 0, longestLongName - longName.length());
                }
                sb.append("  ").append(nameOption.getDescription());
                if (!nameOption.isRequired()) continue;
                sb.append(" (required)");
            }
        }
        if (!after.equals("")) {
            sb.append("\n");
        }
        return sb.append(after).toString();
    }

    protected <T> List<OptionInfo> extract(Class<T> classType) {
        Field[] fields;
        ArrayList<OptionInfo> options = new ArrayList<OptionInfo>();
        for (Field field : fields = classType.getDeclaredFields()) {
            if (field.isAnnotationPresent(Ignore.class) || field.isAnnotationPresent(GetOptOrdered.class)) continue;
            options.add(new OptionInfo(field));
        }
        return options;
    }

    public GetOpt setOut(PrintStream out) {
        this.out = out;
        return this;
    }

    public GetOpt setErr(PrintStream err) {
        this.err = err;
        return this;
    }

    public GetOpt setExitMechanism(ExitMechanism exitMechanism) {
        this.exitMechanism = exitMechanism;
        return this;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }
}

