/*
 * Decompiled with CFR 0.152.
 */
package pro.johndunlap.getopt;

import java.lang.reflect.Field;
import pro.johndunlap.getopt.Parser;
import pro.johndunlap.getopt.annotation.Arg;
import pro.johndunlap.getopt.annotation.Ignore;

public class OptionInfo {
    private String flag = "";
    private char code = (char)32;
    private String description = "";
    private String category = "";
    private boolean required = false;

    public OptionInfo(Field field) {
        if (field.isAnnotationPresent(Ignore.class)) {
            throw new RuntimeException("Cannot process ignored field");
        }
        Arg property = field.getAnnotation(Arg.class);
        this.flag = Parser.camelCaseToHyphenCase(field.getName());
        if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            this.description = "Boolean flag which requires no argument";
        } else {
            this.description = "Accepts a ";
            this.description = field.getType().equals(String.class) ? this.description + "string value" : (field.getType().equals(Double.class) || field.getType().equals(Double.TYPE) || field.getType().equals(Float.class) || field.getType().equals(Float.TYPE) ? this.description + "floating point number" : (field.getType().equals(Character.class) || field.getType().equals(Character.TYPE) ? this.description + "single character" : this.description + "number"));
        }
        if (property != null) {
            if (!property.flag().equals("")) {
                this.flag = property.flag();
            }
            if (property.code() != ' ') {
                this.code = property.code();
            }
            if (!property.description().equals("")) {
                this.description = property.description();
            }
            if (!property.category().equals("")) {
                this.category = property.category();
            }
            this.required = property.required();
        }
    }

    public String getFlag() {
        return this.flag;
    }

    public char getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isRequired() {
        return this.required;
    }
}

