/*
 * Decompiled with CFR 0.152.
 */
package pro.johndunlap.getopt;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import pro.johndunlap.getopt.DefaultValueParser;
import pro.johndunlap.getopt.Parser;
import pro.johndunlap.getopt.ReflectionUtil;
import pro.johndunlap.getopt.TypeConverter;
import pro.johndunlap.getopt.annotation.Arg;
import pro.johndunlap.getopt.annotation.GetOptOrdered;
import pro.johndunlap.getopt.annotation.Help;
import pro.johndunlap.getopt.annotation.Ignore;
import pro.johndunlap.getopt.exception.DuplicateOptionException;
import pro.johndunlap.getopt.exception.InaccessibleFieldException;
import pro.johndunlap.getopt.exception.MissingNoArgConstructorException;
import pro.johndunlap.getopt.exception.ParseException;
import pro.johndunlap.getopt.exception.RethrownException;
import pro.johndunlap.getopt.exception.UnsupportedTypeConversionException;

public class ParseContext<T> {
    private final Map<String, Field> namedFields = new HashMap<String, Field>();
    private final List<Field> orderedFields = new ArrayList<Field>();
    private final List<Field> requiredFields = new ArrayList<Field>();
    private final Stack<String> queue;
    private final T instance;
    private final Map<Class<?>, TypeConverter<?>> typeConverters;
    private final Set<String> helpTokens = new HashSet<String>();
    private String currentName;
    private int currentOrderedIndex = 0;
    private boolean helpRequested = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParseContext(Class<T> classType, String[] args, Map<Class<?>, TypeConverter<?>> typeConverters) throws ParseException {
        this.queue = new Stack();
        this.typeConverters = typeConverters;
        Help helpAnnotation = classType.getDeclaredAnnotation(Help.class) != null ? classType.getDeclaredAnnotation(Help.class) : GetDefaults.class.getDeclaredAnnotation(Help.class);
        for (String token : helpAnnotation.helpTokens()) {
            this.helpTokens.add(token);
        }
        for (int i = args.length - 1; i >= 0; --i) {
            this.queue.push(args[i]);
        }
        try {
            this.instance = classType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            String message = String.format("Class %s must have a public no-arg constructor", classType.getCanonicalName());
            throw new MissingNoArgConstructorException(message, e, classType);
        }
        for (Field field : classType.getDeclaredFields()) {
            String longName;
            if (field.getAnnotation(Ignore.class) != null) continue;
            GetOptOrdered orderedAnnotation = field.getAnnotation(GetOptOrdered.class);
            if (orderedAnnotation != null) {
                this.orderedFields.add(field);
                if (!orderedAnnotation.required()) continue;
                this.requiredFields.add(field);
                continue;
            }
            Arg namedOption = field.getAnnotation(Arg.class);
            if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
                try {
                    ReflectionUtil.setFieldValue(field, this.instance, false);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (namedOption != null) {
                if (namedOption.required()) {
                    this.requiredFields.add(field);
                }
                if (!namedOption.flag().equals("")) {
                    if (this.namedFields.containsKey(namedOption.flag())) throw new DuplicateOptionException("Duplicate option name: " + namedOption.flag(), field);
                    this.namedFields.put(namedOption.flag(), field);
                } else {
                    longName = Parser.camelCaseToHyphenCase(field.getName());
                    if (!this.namedFields.containsKey(longName)) {
                        this.namedFields.put(longName, field);
                    }
                }
                if (namedOption.code() == ' ') continue;
                if (this.namedFields.containsKey("" + namedOption.code())) throw new DuplicateOptionException("Duplicate option name: " + namedOption.code(), field);
                this.namedFields.put("" + namedOption.code(), field);
                continue;
            }
            longName = Parser.camelCaseToHyphenCase(field.getName());
            if (this.namedFields.containsKey(longName)) continue;
            this.namedFields.put(longName, field);
        }
        this.orderedFields.sort((f1, f2) -> {
            GetOptOrdered f1o = f1.getAnnotation(GetOptOrdered.class);
            GetOptOrdered f2o = f2.getAnnotation(GetOptOrdered.class);
            return Integer.compare(f1o.order(), f2o.order());
        });
    }

    public ParseContext<T> setCurrentName(String currentName) {
        this.currentName = currentName;
        return this;
    }

    public T getInstance() {
        return this.instance;
    }

    public Stack<String> getQueue() {
        return this.queue;
    }

    public void setOrderedValue(String stringValue) throws ParseException {
        int orderedIndex = this.currentOrderedIndex;
        try {
            Field field = this.orderedFields.get(this.currentOrderedIndex++);
            GetOptOrdered ordered = field.getAnnotation(GetOptOrdered.class);
            if (ordered == null) {
                throw new NullPointerException(GetOptOrdered.class.getName() + " is missing. This should never happen");
            }
            TypeConverter<?> typeConverter = null;
            if (this.typeConverters.containsKey(field.getType())) {
                typeConverter = this.typeConverters.get(field.getType());
            } else if (!ordered.converter().equals(DefaultValueParser.class)) {
                try {
                    Class<TypeConverter<?>> parserClass = ordered.converter();
                    typeConverter = parserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    String message = String.format("Class %s must have a public no-arg constructor", ordered.converter().getCanonicalName());
                    throw new RethrownException(message, e);
                }
            }
            Class<?> fieldType = field.getType();
            Object existingValue = ReflectionUtil.getFieldValue(field, this.instance);
            if (Collection.class.isAssignableFrom(fieldType) || fieldType.isArray()) {
                Object parsedValue = this.parse(stringValue, ordered.collectionType(), typeConverter);
                existingValue = this.addToCollection(field, existingValue, fieldType, ordered.collectionType(), parsedValue);
                ReflectionUtil.setFieldValue(field, this.instance, existingValue);
            } else {
                Object parsedValue = this.parse(stringValue, fieldType, typeConverter);
                ReflectionUtil.setFieldValue(field, this.instance, parsedValue);
            }
        }
        catch (IllegalAccessException | RuntimeException e) {
            String message = String.format("Failed to set value %s for position %s", stringValue, orderedIndex);
            throw new InaccessibleFieldException(message, e, this.instance.getClass());
        }
    }

    protected Object addToCollection(Field field, Object collection, Class<?> collectionType, Class<?> elementType, Object parsedValue) {
        if (collection == null) {
            if (Collection.class.isAssignableFrom(collectionType)) {
                if (List.class.isAssignableFrom(collectionType)) {
                    collection = new ArrayList();
                } else if (Set.class.isAssignableFrom(collectionType)) {
                    collection = new HashSet();
                } else if (Queue.class.isAssignableFrom(collectionType)) {
                    collection = new LinkedList();
                } else {
                    throw new AssertionError((Object)(collectionType.getCanonicalName() + " is not a supported collection type. To work around this, please initialize " + field + " with an empty collection."));
                }
                ((Collection)collection).add(parsedValue);
            } else if (collectionType.isArray()) {
                collection = Array.newInstance(elementType, 1);
                ((Object[])collection)[0] = parsedValue;
            }
        } else if (Collection.class.isAssignableFrom(collectionType)) {
            ((Collection)collection).add(parsedValue);
        } else if (collectionType.isArray()) {
            ArrayList<Object> tmpList = new ArrayList<Object>(Arrays.asList((Object[])collection));
            tmpList.add(parsedValue);
            collection = tmpList.toArray(new Object[0]);
        }
        return collection;
    }

    public void setNamedValue(String value) throws ParseException {
        try {
            Field field = this.namedFields.get(this.currentName);
            if (field == null) {
                return;
            }
            Arg named = field.getAnnotation(Arg.class);
            Class<?> fieldType = field.getType();
            TypeConverter typeConverter = null;
            if (this.typeConverters.containsKey(fieldType)) {
                typeConverter = this.typeConverters.get(fieldType);
            } else if (named != null && !named.converter().equals(DefaultValueParser.class)) {
                typeConverter = (TypeConverter)ReflectionUtil.instantiate(named.converter());
            }
            Object existingValue = ReflectionUtil.getFieldValue(field, this.instance);
            if (Collection.class.isAssignableFrom(fieldType) || fieldType.isArray()) {
                if (named == null) {
                    String message = Arg.class.getName() + " is missing. This should never happen";
                    throw new NullPointerException(message);
                }
                Object parsedValue = this.parse(value, named.collectionType(), typeConverter);
                existingValue = this.addToCollection(field, existingValue, fieldType, named.collectionType(), parsedValue);
                ReflectionUtil.setFieldValue(field, this.instance, existingValue);
            } else {
                Object parsedValue = this.parse(value, field.getType(), typeConverter);
                ReflectionUtil.setFieldValue(field, this.instance, parsedValue);
            }
        }
        catch (IllegalAccessException | RuntimeException e) {
            String message = String.format("Failed to set value %s for flag %s", value, this.currentName);
            throw new InaccessibleFieldException(message, e, this.instance.getClass());
        }
    }

    protected Object parse(String value, Class<?> fieldType, TypeConverter<?> typeConverter) throws ParseException {
        Comparable<Integer> parsed = null;
        try {
            if (fieldType.equals(String.class)) {
                return value;
            }
            if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
                parsed = Integer.parseInt(value);
            } else if (fieldType.equals(Short.class) || fieldType.equals(Short.TYPE)) {
                parsed = Short.parseShort(value);
            } else if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                parsed = Long.parseLong(value);
            } else if (fieldType.equals(Float.class) || fieldType.equals(Float.TYPE)) {
                parsed = Float.valueOf(Float.parseFloat(value));
            } else if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
                parsed = Double.parseDouble(value);
            } else if (fieldType.equals(Byte.class) || fieldType.equals(Byte.TYPE)) {
                parsed = Byte.parseByte(value);
            } else if (fieldType.equals(BigInteger.class)) {
                parsed = new BigInteger(value);
            } else if (fieldType.equals(BigDecimal.class)) {
                parsed = new BigDecimal(value);
            } else if (fieldType.equals(Character.class) || fieldType.equals(Character.TYPE)) {
                if (value == null || value.length() != 1) {
                    throw new ParseException(value, String.format("Value %s must contain exactly one character", value));
                }
                parsed = Character.valueOf(value.charAt(0));
            } else {
                if (ParseContext.isBoolean(fieldType)) {
                    if (value == null) {
                        return false;
                    }
                    return Boolean.parseBoolean(value);
                }
                if (typeConverter != null) {
                    try {
                        parsed = typeConverter.read(value);
                    }
                    catch (Exception e) {
                        throw new RethrownException(e);
                    }
                } else {
                    throw new UnsupportedTypeConversionException("Unsupported type: " + fieldType.getCanonicalName());
                }
            }
            return parsed;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(value, String.format("Failed to parse string %s into an instance of class %s", value, fieldType));
        }
    }

    private static boolean isBoolean(Class<?> type) {
        return type.equals(Boolean.class) || type.equals(Boolean.TYPE);
    }

    public boolean isBoolean() {
        Field field = this.namedFields.get(this.currentName);
        if (field == null) {
            return false;
        }
        return ParseContext.isBoolean(field.getType());
    }

    public List<Field> getRequiredFields() {
        return this.requiredFields;
    }

    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    public ParseContext<T> setHelpRequested(boolean helpRequested) {
        this.helpRequested = helpRequested;
        return this;
    }

    public boolean isHelpToken(String token) {
        return this.helpTokens.contains(token);
    }

    @Help
    private static class GetDefaults {
        private GetDefaults() {
        }
    }
}

