/*
 * Decompiled with CFR 0.152.
 */
package pro.johndunlap.getopt;

import pro.johndunlap.getopt.ParseContext;
import pro.johndunlap.getopt.exception.ParseException;
import pro.johndunlap.getopt.exception.RethrownException;

public enum Parser {
    NEUTRAL{

        @Override
        protected <T> Parser execute(ParseContext<T> context) throws ParseException {
            try {
                if (context.getQueue().size() == 0) {
                    return null;
                }
                String arg = context.getQueue().peek();
                if (arg.charAt(0) == '-') {
                    if (arg.charAt(1) != '-') {
                        if (arg.length() == 2) {
                            return FLAG;
                        }
                        arg = context.getQueue().pop();
                        char[] characters = arg.substring(1).toCharArray();
                        for (int i = characters.length - 1; i >= 0; --i) {
                            context.getQueue().push("-" + characters[i]);
                        }
                    }
                    return FLAG;
                }
                context.setOrderedValue(arg);
                context.getQueue().pop();
                return NEUTRAL;
            }
            catch (RuntimeException e) {
                throw new RethrownException(e);
            }
        }
    }
    ,
    FLAG{

        @Override
        protected <T> Parser execute(ParseContext<T> context) throws ParseException {
            try {
                String arg = context.getQueue().pop();
                if (context.isHelpToken(arg)) {
                    context.setHelpRequested(true);
                }
                if (arg.charAt(0) == '-') {
                    if (arg.charAt(1) == '-') {
                        context.setCurrentName(arg.substring(2));
                    } else {
                        context.setCurrentName(arg.substring(1));
                    }
                    return VALUE;
                }
                context.setOrderedValue(arg);
                context.getQueue().pop();
                return NEUTRAL;
            }
            catch (RuntimeException e) {
                throw new RethrownException(e);
            }
        }
    }
    ,
    VALUE{

        @Override
        protected <T> Parser execute(ParseContext<T> context) throws ParseException {
            try {
                if (context.isBoolean()) {
                    context.setNamedValue("true");
                    return NEUTRAL;
                }
                if (context.getQueue().size() == 0) {
                    return null;
                }
                context.setNamedValue(context.getQueue().pop());
                return NEUTRAL;
            }
            catch (RuntimeException e) {
                throw new RethrownException(e);
            }
        }
    };


    protected abstract <T> Parser execute(ParseContext<T> var1) throws ParseException;

    public static String camelCaseToHyphenCase(String camelCase) {
        StringBuilder hyphenCase = new StringBuilder();
        char firstCharacter = camelCase.charAt(0);
        hyphenCase.append(Character.toLowerCase(firstCharacter));
        for (int x = 1; x < camelCase.length(); ++x) {
            char currentCharacter = camelCase.charAt(x);
            if (Character.isUpperCase(currentCharacter)) {
                hyphenCase.append('-').append(Character.toLowerCase(currentCharacter));
                continue;
            }
            hyphenCase.append(currentCharacter);
        }
        return hyphenCase.toString();
    }

    public static String hyphenCaseToCamelCase(String hyphenCase) {
        String[] parts = hyphenCase.split("-");
        StringBuilder sb = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            char[] chars = part.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            part = new String(chars);
            sb.append(part);
        }
        return sb.toString();
    }
}

