/*
 * Decompiled with CFR 0.152.
 */
package pro.johndunlap.getopt;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import pro.johndunlap.getopt.exception.MissingNoArgConstructorException;
import pro.johndunlap.getopt.exception.ParseException;

public class ReflectionUtil {
    private ReflectionUtil() {
        throw new RuntimeException("This class cannot be instantiated");
    }

    public static Object getFieldValue(Field field, Object instance) throws IllegalAccessException {
        Method getterMethod = ReflectionUtil.findGetterMethod(field);
        try {
            return getterMethod.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | NullPointerException | InvocationTargetException e1) {
            try {
                return field.get(instance);
            }
            catch (IllegalAccessException e2) {
                try {
                    getterMethod.setAccessible(true);
                    return getterMethod.invoke(instance, new Object[0]);
                }
                catch (IllegalAccessException | NullPointerException | InvocationTargetException e3) {
                    field.setAccessible(true);
                    return field.get(instance);
                }
            }
        }
    }

    public static <T> T instantiate(Class<?> type) throws MissingNoArgConstructorException {
        try {
            Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            String message = String.format("Unable to instantiate class %s", type.getName());
            throw new MissingNoArgConstructorException(message, e, type);
        }
    }

    public static void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
        Method setterMethod = ReflectionUtil.findSetterMethod(field);
        try {
            setterMethod.invoke(instance, value);
        }
        catch (IllegalAccessException | NullPointerException | InvocationTargetException e1) {
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException e2) {
                try {
                    setterMethod.setAccessible(true);
                    setterMethod.invoke(instance, value);
                }
                catch (IllegalAccessException | NullPointerException | InvocationTargetException e3) {
                    field.setAccessible(true);
                    field.set(instance, value);
                }
            }
        }
    }

    public static Method findSetterMethod(Field field) {
        Method setterMethod;
        String setterName = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        try {
            Class<?> declaringClass = field.getDeclaringClass();
            Class<?> type = field.getType();
            setterMethod = declaringClass.getDeclaredMethod(setterName, type);
        }
        catch (NoSuchMethodException e) {
            setterMethod = null;
        }
        return setterMethod;
    }

    public static Method findGetterMethod(Field field) {
        Method getterMethod;
        String getterName = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        try {
            Class<?> declaringClass = field.getDeclaringClass();
            getterMethod = declaringClass.getDeclaredMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getterMethod = null;
        }
        return getterMethod;
    }

    public static Constructor<?> getNoArgConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> noArgConstructor = null;
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterCount() != 0) continue;
            noArgConstructor = constructor;
            break;
        }
        return noArgConstructor;
    }

    public static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public boolean isArray(Class<?> clazz) {
        return clazz.isArray();
    }

    public static Object instantiateCollection(Class<Collection<?>> collectionClass) {
        throw new RuntimeException("IMPLEMENT ME");
    }

    public static <T> T parse(Class<T> fieldType, String value) throws ParseException {
        if (fieldType == null) {
            throw new ParseException("Field type cannot be null");
        }
        if (fieldType.equals(String.class)) {
            return (T)value;
        }
        if (ReflectionUtil.isInteger(fieldType)) {
            return (T)Integer.valueOf(Integer.parseInt(value));
        }
        if (ReflectionUtil.isShort(fieldType)) {
            return (T)Short.valueOf(Short.parseShort(value));
        }
        if (ReflectionUtil.isLong(fieldType)) {
            return (T)Long.valueOf(Long.parseLong(value));
        }
        if (ReflectionUtil.isFloat(fieldType)) {
            return (T)Float.valueOf(Float.parseFloat(value));
        }
        if (ReflectionUtil.isDouble(fieldType)) {
            return (T)Double.valueOf(Double.parseDouble(value));
        }
        if (ReflectionUtil.isByte(fieldType)) {
            return (T)Byte.valueOf(Byte.parseByte(value));
        }
        if (fieldType.equals(BigInteger.class)) {
            return (T)new BigInteger(value);
        }
        if (fieldType.equals(BigDecimal.class)) {
            return (T)new BigDecimal(value);
        }
        if (ReflectionUtil.isCharacter(fieldType)) {
            if (value == null || value.length() != 1) {
                throw new ParseException(value, String.format("Value \"%s\" must be exactly one character in length", value));
            }
            return (T)Character.valueOf(value.charAt(0));
        }
        if (ReflectionUtil.isBoolean(fieldType)) {
            if (value == null) {
                return (T)Boolean.valueOf(false);
            }
            return (T)Boolean.valueOf(Boolean.parseBoolean(value));
        }
        throw new ParseException("Unable to parse value " + value + " into type " + fieldType);
    }

    public static boolean isBoolean(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.equals(Boolean.class) || type.equals(Boolean.TYPE);
    }

    public static boolean isInteger(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.equals(Integer.class) || type.equals(Integer.TYPE);
    }

    public static boolean isShort(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.equals(Short.class) || type.equals(Short.TYPE);
    }

    public static boolean isLong(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.equals(Long.class) || type.equals(Long.TYPE);
    }

    public static boolean isFloat(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.equals(Float.class) || type.equals(Float.TYPE);
    }

    public static boolean isDouble(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.equals(Double.class) || type.equals(Double.TYPE);
    }

    public static boolean isByte(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.equals(Byte.class) || type.equals(Byte.TYPE);
    }

    public static boolean isCharacter(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.equals(Character.class) || type.equals(Character.TYPE);
    }
}

