(defproject pro.juxt.clojars-forks.edn-query-language/eql "2021.02.28"
  :description "EDN Query Language support library"
  :url "https://github.com/edn-query-language/eql"
  :license {:name "MIT" :url "https://opensource.org/licenses/MIT"}

  :plugins [[lein-tools-deps "0.4.1"]]
  :middleware [lein-tools-deps.plugin/resolve-dependencies-with-deps-edn]
  :lein-tools-deps/config {:config-files [:install :user :project]
                           :clojure-executables ["/usr/local/bin/clojure"
                                                 "/usr/bin/clojure"]}

  :jar-exclusions [#"public/.*" #"\.DS_Store"]

 ;; JUXT additions
  :pom-addition ([:developers
                  [:developer
                   [:id "wilkerlucio"]
                   [:name "Wilker Lúcio"]]])
  :repositories {"releases" {:url "https://oss.sonatype.org/service/local/staging/deploy/maven2"
                             :creds :gpg}
                 "snapshots" {:url "https://oss.sonatype.org/content/repositories/snapshots"
                              :creds :gpg}} )
