/*
 * Decompiled with CFR 0.152.
 */
package cruxhttpserverdeps002.reitit;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;

public class Trie {
    private static String decode(String string, boolean bl, boolean bl2) {
        try {
            if (bl) {
                return URLDecoder.decode(bl2 ? string.replace("+", "%2B") : string, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    private static String decode(char[] cArray, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        block4: for (int i = n; i < n2; ++i) {
            switch (cArray[i]) {
                case '%': {
                    bl = true;
                    continue block4;
                }
                case '+': {
                    bl2 = true;
                }
            }
        }
        return Trie.decode(new String(cArray, n, n2 - n), bl, bl2);
    }

    public static StaticMatcher staticMatcher(String string, Matcher matcher) {
        return new StaticMatcher(string, matcher);
    }

    public static DataMatcher dataMatcher(IPersistentMap iPersistentMap, Object object) {
        return new DataMatcher(iPersistentMap, object);
    }

    public static WildMatcher wildMatcher(Keyword keyword, char c, Matcher matcher) {
        return new WildMatcher(keyword, c, matcher);
    }

    public static CatchAllMatcher catchAllMatcher(Keyword keyword, IPersistentMap iPersistentMap, Object object) {
        return new CatchAllMatcher(keyword, iPersistentMap, object);
    }

    public static LinearMatcher linearMatcher(List<Matcher> list, boolean bl) {
        return new LinearMatcher(list, bl);
    }

    public static Object lookup(Matcher matcher, String string) {
        return matcher.match(0, string.length(), string.toCharArray());
    }

    public static void main(String[] stringArray) {
        LinearMatcher linearMatcher = Trie.linearMatcher(Arrays.asList(Trie.staticMatcher("/auth/", Trie.linearMatcher(Arrays.asList(Trie.staticMatcher("login", Trie.dataMatcher((IPersistentMap)PersistentArrayMap.EMPTY, 1)), Trie.staticMatcher("recovery", Trie.dataMatcher((IPersistentMap)PersistentArrayMap.EMPTY, 2))), true))), true);
        System.err.println(linearMatcher);
        System.out.println(Trie.lookup(linearMatcher, "/auth/login"));
        System.out.println(Trie.lookup(linearMatcher, "/auth/recovery"));
    }

    static final class LinearMatcher
    implements Matcher {
        private final Matcher[] childs;
        private final int size;

        LinearMatcher(List<Matcher> list, boolean bl) {
            this.childs = list.toArray(new Matcher[0]);
            if (!bl) {
                Arrays.sort(this.childs, Comparator.comparing(Matcher::depth).thenComparing(Matcher::length).reversed());
            }
            this.size = list.size();
        }

        @Override
        public Match match(int n, int n2, char[] cArray) {
            for (int i = 0; i < this.size; ++i) {
                Match match = this.childs[i].match(n, n2, cArray);
                if (match == null) continue;
                return match;
            }
            return null;
        }

        @Override
        public int depth() {
            return Arrays.stream(this.childs).mapToInt(Matcher::depth).max().orElseThrow(NoSuchElementException::new) + 1;
        }

        @Override
        public int length() {
            return 0;
        }

        public String toString() {
            return Arrays.toString(this.childs);
        }
    }

    static final class CatchAllMatcher
    implements Matcher {
        private final Keyword parameter;
        private final IPersistentMap params;
        private final Object data;

        CatchAllMatcher(Keyword keyword, IPersistentMap iPersistentMap, Object object) {
            this.parameter = keyword;
            this.params = iPersistentMap;
            this.data = object;
        }

        @Override
        public Match match(int n, int n2, char[] cArray) {
            if (n <= n2) {
                return new Match(this.params, this.data).assoc(this.parameter, Trie.decode(cArray, n, n2));
            }
            return null;
        }

        @Override
        public int depth() {
            return 1;
        }

        @Override
        public int length() {
            return 0;
        }

        public String toString() {
            return "[" + this.parameter + " " + new DataMatcher(null, this.data) + "]";
        }
    }

    static final class WildMatcher
    implements Matcher {
        private final Keyword key;
        private final char end;
        private final Matcher child;

        WildMatcher(Keyword keyword, char c, Matcher matcher) {
            this.key = keyword;
            this.end = c;
            this.child = matcher;
        }

        @Override
        public Match match(int n, int n2, char[] cArray) {
            boolean bl = false;
            boolean bl2 = false;
            if (n < n2 && cArray[n] != this.end) {
                Match match;
                int n3 = n2;
                for (int i = n; i < n2; ++i) {
                    char c = cArray[i];
                    bl = bl || c == '%';
                    boolean bl3 = bl2 = bl2 || c == '+';
                    if (c != this.end) continue;
                    n3 = i;
                    break;
                }
                return (match = this.child.match(n3, n2, cArray)) != null ? match.assoc(this.key, Trie.decode(new String(cArray, n, n3 - n), bl, bl2)) : null;
            }
            return null;
        }

        @Override
        public int depth() {
            return this.child.depth() + 1;
        }

        @Override
        public int length() {
            return 0;
        }

        public String toString() {
            return "[" + this.key + " " + this.child + "]";
        }
    }

    static final class DataMatcher
    implements Matcher {
        private final Match match;

        DataMatcher(IPersistentMap iPersistentMap, Object object) {
            this.match = new Match(iPersistentMap, object);
        }

        @Override
        public Match match(int n, int n2, char[] cArray) {
            if (n == n2) {
                return this.match;
            }
            return null;
        }

        @Override
        public int depth() {
            return 1;
        }

        @Override
        public int length() {
            return 0;
        }

        public String toString() {
            return this.match.data != null ? this.match.data.toString() : "nil";
        }
    }

    static final class StaticMatcher
    implements Matcher {
        private final Matcher child;
        private final char[] path;
        private final int size;

        StaticMatcher(String string, Matcher matcher) {
            this.path = string.toCharArray();
            this.size = string.length();
            this.child = matcher;
        }

        @Override
        public Match match(int n, int n2, char[] cArray) {
            if (n2 < n + this.size) {
                return null;
            }
            for (int i = 0; i < this.size; ++i) {
                if (cArray[i + n] == this.path[i]) continue;
                return null;
            }
            return this.child.match(n + this.size, n2, cArray);
        }

        @Override
        public int depth() {
            return this.child.depth() + 1;
        }

        @Override
        public int length() {
            return this.path.length;
        }

        public String toString() {
            return "[\"" + new String(this.path) + "\" " + this.child + "]";
        }
    }

    public static interface Matcher {
        public Match match(int var1, int var2, char[] var3);

        public int depth();

        public int length();
    }

    public static final class Match {
        public final IPersistentMap params;
        public final Object data;

        public Match(IPersistentMap iPersistentMap, Object object) {
            this.params = iPersistentMap;
            this.data = object;
        }

        Match assoc(Object object, Object object2) {
            return new Match(this.params.assoc(object, object2), this.data);
        }

        public String toString() {
            HashMap<Keyword, Object> hashMap = new HashMap<Keyword, Object>();
            hashMap.put(Keyword.intern((String)"data"), this.data);
            hashMap.put(Keyword.intern((String)"params"), this.params);
            return ((Object)hashMap).toString();
        }
    }
}

