/*
 * Decompiled with CFR 0.152.
 */
package pro.leaco.jooq.generator;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectQuery;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.codegen.JavaGenerator;
import org.jooq.codegen.JavaWriter;
import org.jooq.impl.DSL;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.TableDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.leaco.jooq.generator.ClassGenerateUtil;

public class FJavaGenerator
extends JavaGenerator {
    private static final Logger logger = LoggerFactory.getLogger(FJavaGenerator.class);

    protected void printRecordTypeMethod(JavaWriter out, Definition definition) {
        super.printRecordTypeMethod(out, definition);
        try {
            TableDefinition table = (TableDefinition)definition;
            this.generateParseMethod(out, table);
            this.generaterConditionFormMethod(out, table);
            this.generateSortFormMethod(out, table);
            ClassGenerateUtil.generateSqlFilterInnerClass(out);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void generateDaoClassFooter(TableDefinition table, JavaWriter out) {
        super.generateDaoClassFooter(table, out);
        this.generateCreateQueryMethod(table, out);
        this.generateFetchPageMethod(table, out);
    }

    protected void generateParseMethod(JavaWriter out, TableDefinition table) {
        ((JavaWriter)out.tab(1)).javadoc("\u901a\u8fc7\u5b57\u7b26\u4e32\u89e3\u6790\u5217\u5c5e\u6027", new Object[0]);
        ((JavaWriter)out.tab(1)).println("public %s parse(%s property) {", new Object[]{Field.class, String.class});
        ((JavaWriter)out.tab(2)).println("if (property == null) {\n            throw new %s(\"property can not be  null\");\n        }", new Object[]{IllegalArgumentException.class});
        ((JavaWriter)out.tab(2)).println("String _p = property.replaceAll(\"_\", \"\").toLowerCase();");
        ((JavaWriter)out.tab(2)).println("switch (_p) {");
        for (ColumnDefinition column : table.getColumns()) {
            String columnId = this.getStrategy().getJavaIdentifier((Definition)column);
            String columnName = column.getName();
            ((JavaWriter)out.tab(3)).println("case \"%s\":", new Object[]{this.escape(columnName)});
            ((JavaWriter)out.tab(4)).println("return this.%s;", new Object[]{columnId});
        }
        ((JavaWriter)out.tab(3)).println("default: break;");
        ((JavaWriter)out.tab(2)).println("}");
        ((JavaWriter)out.tab(2)).println("throw new %s(\"can not found property\" + property);", new Object[]{IllegalArgumentException.class});
        ((JavaWriter)out.tab(1)).println("}");
    }

    private String escape(String column) {
        String res = RegExUtils.replaceAll((String)column, (String)"_", (String)"");
        return StringUtils.lowerCase((String)res);
    }

    protected void generaterConditionFormMethod(JavaWriter out, TableDefinition table) {
        ((JavaWriter)out.tab(1)).println("protected enum Opera {\n        AND(\"a\", (a, b) -> a.and(b)),\n        OR(\"o\", (a, b) -> a.or(b)),\n        ;\n\n        private final String code;\n        private final %s<Condition, Condition, Condition> action;\n\n        Opera(String code, BiFunction<Condition, Condition, Condition> action) {\n            this.code = code;\n            this.action = action;\n        }\n\n        protected final Condition operate(Condition a, Condition b) {\n            if (a == null) {\n                return b;\n            } else if (b == null) {\n                return a;\n            }\n            return action.apply(a, b);\n        }\n\n        protected static Opera parse(String code) {\n            if (code == null) {\n                throw new IllegalArgumentException(\"opera code error\");\n            }\n            String _code = code.toLowerCase();\n            for (Opera value : values()) {\n                if (value.code.equals(_code)) {\n                    return value;\n                }\n            }\n            throw new IllegalArgumentException(\"opera code error,can not found operate:\" + code);\n        }\n    }", new Object[]{BiFunction.class});
        ((JavaWriter)out.tab(1)).javadoc("\u4eceurl\u53c2\u6570\u4e2d\u6784\u5efa\u6761\u4ef6", new Object[0]);
        ((JavaWriter)out.tab(1)).println("public %s buildCondition(%s<String, Object> params){", new Object[]{Condition.class, Map.class});
        ((JavaWriter)out.tab(2)).println("if (params == null || params.isEmpty()) {");
        ((JavaWriter)out.tab(3)).println("return %s.trueCondition();", new Object[]{DSL.class});
        ((JavaWriter)out.tab(2)).println("}");
        ((JavaWriter)out.tab(2)).println("SQLFilter.filter(params);\n        java.util.Iterator entries = params.entrySet().iterator();\n        Condition condition = null;\n        while (entries.hasNext()) {\n            %s.Entry entry = (%s.Entry) entries.next();\n            String expression = entry.getKey().toString();\n            String value = entry.getValue().toString();\n            if (%s.matches(\"w[a-z]{3}_[a-zA-Z$_]+\", expression)) {\n                condition = solveCondition(condition, expression, value);\n            }\n        }\n        if(condition==null){\n            return %s.trueCondition();\n        } else {\n            return condition;\n        }\n    }\n", new Object[]{Map.class, Map.class, Pattern.class, DSL.class});
        ((JavaWriter)out.tab(1)).println("protected Condition solveCondition(Condition condition, String expression, String value) {\n        if (expression == null || \"\".equals(expression)) {\n            return condition;\n        }\n        String logicExp = expression.substring(1, 2);\n        Opera opera = Opera.parse(logicExp);\n        String compPrefix = expression.substring(2, 4);\n        String propName = SQLFilter.escape(expression.substring(5));\n        Field field = parse(propName);\n        switch (compPrefix) {\n            case \"eq\":\n                if (value != null) {\n                    return opera.operate(condition, field.eq(value));\n                } else {\n                    return condition;\n                }\n            case \"ne\":\n                if (value != null) {\n                    return opera.operate(condition, field.ne(value));\n                } else {\n                    return condition;\n                }\n            case \"gt\":\n                if (value != null) {\n                    return opera.operate(condition, field.gt(value));\n                } else {\n                    return condition;\n                }\n            case \"ge\":\n                if (value != null) {\n                    return opera.operate(condition, field.ge(value));\n                } else {\n                    return condition;\n                }\n            case \"lt\":\n                if (value != null) {\n                    return opera.operate(condition, field.lt(value));\n                } else {\n                    return condition;\n                }\n            case \"le\":\n                if (value != null) {\n                    return opera.operate(condition, field.le(value));\n                } else {\n                    return condition;\n                }\n            case \"lk\":\n                if (value != null && !\"\".equals(value)) {\n                    return opera.operate(condition, field.like(\"%\" + value + \"%\"));\n                } else {\n                    return condition;\n                }\n            case \"in\":\n                if (value instanceof String) {\n                    String v = (String) value;\n                    if (v != null && !\"\".equals(v)) {\n                        String[] split = v.split(\",\");\n                        if (split != null && split.length > 0) {\n                            java.util.ArrayList<String> strings = new java.util.ArrayList<>();\n                            for (String s : split) {\n                                strings.add(s);\n                            }\n                            return opera.operate(condition, field.in(strings));\n                        }\n                    }\n                }\n                return condition;\n            case \"ep\":\n                return opera.operate(condition, field.eq(\"\"));\n            case \"np\":\n                return opera.operate(condition, field.ne(\"\"));\n            case \"eu\":\n                return opera.operate(condition, field.isNull());\n            case \"nu\":\n                return opera.operate(condition, field.isNotNull());\n            default:\n                break;\n        }\n        throw new IllegalArgumentException(\"expression compare word error\");\n    }");
    }

    protected void generateSortFormMethod(JavaWriter out, TableDefinition table) {
        out.println("    private static int compareValue(Object a, Object b) {\n        if (a == null) {\n            return -1;\n        } else if (b == null) {\n            return 1;\n        } else {\n            int _a;\n            try {\n                _a = Integer.parseInt(a.toString());\n            } catch (Exception e) {\n                return -1;\n            }\n            int _b;\n            try {\n                _b = Integer.parseInt(b.toString());\n            } catch (Exception e) {\n                return 1;\n            }\n            return Integer.compare(_a, _b);\n        }\n    }");
        ((JavaWriter)out.tab(1)).javadoc("\u4eceurl\u53c2\u6570\u4e2d\u6784\u5efa\u6392\u5e8f", new Object[0]);
        ((JavaWriter)out.tab(1)).println(" public SortField[] buildOrderBy(Map<String, Object> params, SortField... otherField) {\n        return %s.concat(\n                %s.ofNullable(otherField)\n                        .map(%s::stream)\n                        .orElse(Stream.empty())\n                        .filter(Objects::nonNull),\n                Arrays.stream(buildOrderBy(params))\n        ).toArray(SortField[]::new);\n    }", new Object[]{Stream.class, Optional.class, Arrays.class});
        ((JavaWriter)out.tab(1)).javadoc("\u4eceurl\u53c2\u6570\u4e2d\u6784\u5efa\u6392\u5e8f", new Object[0]);
        ((JavaWriter)out.tab(1)).println("public %s[] buildOrderBy(Map<String, Object> params) {\n", new Object[]{SortField.class});
        ((JavaWriter)out.tab(1)).println("        if (params == null || params.isEmpty()) {\n            return new SortField[0];\n        }\n        SQLFilter.filter(params);\n        return params.entrySet().stream()\n                .filter(x -> Pattern.matches(\"o(a|d)_[$_a-zA-Z]+\", x.getKey()))\n                .sorted((x, y) -> compareValue(x.getValue(), y.getValue()))\n                .map(entry -> {\n                    String expression = entry.getKey();\n                    String value = entry.getValue().toString();\n                    String orderPrefix = expression.substring(1, 2);\n                    String propName = SQLFilter.escape(expression.substring(3));\n                    Field field = parse(propName);\n                    switch (orderPrefix) {\n                        case \"a\":\n                            return field.sort(%s.ASC);\n                        case \"d\":\n                            return field.sort(%s.DESC);\n                        default:\n                            throw new %s();\n                    }\n                })\n                .filter(%s::nonNull)\n                .toArray(SortField[]::new);\n    }", new Object[]{SortOrder.class, SortOrder.class, AssertionError.class, Objects.class});
    }

    private void generateCreateQueryMethod(TableDefinition table, JavaWriter out) {
        String recordClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        String tableIdentifier = this.getStrategy().getFullJavaIdentifier((Definition)table);
        ((JavaWriter)out.tab(1)).println(" public %s<%s> createQuery() {\n        return ctx().selectQuery(getTable());\n    }", new Object[]{SelectQuery.class, recordClassName});
        ((JavaWriter)out.tab(1)).println("public SelectQuery<%s> createQuery(%s<String, Object> params) {\n        SelectQuery<%s> query = createQuery();\n        query.addConditions(%s.buildCondition(params));\n        query.addOrderBy(%s.buildOrderBy(params));\n        return query;\n    }", new Object[]{recordClassName, Map.class, recordClassName, tableIdentifier, tableIdentifier});
        ((JavaWriter)out.tab(1)).println("public SelectQuery<%s> createQuery(%s<String, Object> params, %s... fields) {\n        SelectQuery<%s> query = createQuery(params);\n        query.addSelect(fields);\n        return query;\n    }", new Object[]{recordClassName, Map.class, SelectFieldOrAsterisk.class, recordClassName});
    }

    private void generateFetchPageMethod(TableDefinition table, JavaWriter out) {
        String pType = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
        String recordClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        ((JavaWriter)out.tab(1)).javadoc("\u67e5\u8be2\u5206\u9875", new Object[0]);
        ((JavaWriter)out.tab(1)).println("public com.github.pagehelper.Page<%s> fetchPage(Map<String, Object> params) {\n        SelectQuery<%s> query = createQuery(params);\n        return fetchPage(query, params);\n    }", new Object[]{pType, recordClassName});
        ((JavaWriter)out.tab(1)).javadoc("\u67e5\u8be2\u5206\u9875", new Object[0]);
        ((JavaWriter)out.tab(1)).println("public com.github.pagehelper.Page<%s> fetchPage(SelectQuery<?> query, Map<String, Object> params) {\n        int page = (int) %s.ofNullable(params.get(\"page\")).map(Object::toString).map(Integer::parseInt).orElse(1);\n        int limit = (int) Optional.ofNullable(java.util.Optional.ofNullable(params.get(\"limit\")).orElse(params.get(\"pageSize\"))).map(Object::toString).map(Integer::parseInt).orElse(10);\n        return fetchPage(query, page, limit);\n    }", new Object[]{pType, Optional.class});
        ((JavaWriter)out.tab(1)).javadoc("\u67e5\u8be2\u5206\u9875", new Object[0]);
        ((JavaWriter)out.tab(1)).println("public com.github.pagehelper.Page<%s> fetchPage(SelectQuery<?> query, int pageNum, int pageSize) {\n        com.github.pagehelper.Page<%s> page = com.github.pagehelper.PageHelper.startPage(pageNum, pageSize, true, true, false);\n        int total = ctx().fetchCount(query);\n        page.setTotal(total);\n        query.addLimit(page.getStartRow(), page.getPageSize());\n        List<%s> list = ctx().fetch(query).into(this.getType());\n        page.clear();\n        page.addAll(list);\n        return page;\n    }", new Object[]{pType, pType, pType});
        ((JavaWriter)out.tab(1)).javadoc("\u67e5\u8be2\u5206\u9875", new Object[0]);
        ((JavaWriter)out.tab(1)).println("public <M> com.github.pagehelper.Page<M> fetchPage(SelectQuery<?> query, Map<String, Object> params, %s<M> clazz) {\n        int page = (int) %s.ofNullable(params.get(\"page\")).map(Object::toString).map(Integer::parseInt).orElse(1);\n        int limit = (int) Optional.ofNullable(java.util.Optional.ofNullable(params.get(\"limit\")).orElse(params.get(\"pageSize\"))).map(Object::toString).map(Integer::parseInt).orElse(10);\n        return fetchPage(query, page, limit, clazz);\n    }", new Object[]{Class.class, Optional.class});
        ((JavaWriter)out.tab(1)).javadoc("\u67e5\u8be2\u5206\u9875", new Object[0]);
        ((JavaWriter)out.tab(1)).println("public <M> com.github.pagehelper.Page<M> fetchPage(SelectQuery<?> query, int pageNum, int pageSize, %s<M> clazz) {\n        com.github.pagehelper.Page<M> page = com.github.pagehelper.PageHelper.startPage(pageNum, pageSize, true, true, false);\n        int total = ctx().fetchCount(query);\n        page.setTotal(total);\n        query.addLimit(page.getStartRow(), page.getPageSize());\n        List<M> list = fetchList(query, clazz);\n        page.clear();\n        page.addAll(list);\n        return page;\n    }", new Object[]{Class.class});
        ((JavaWriter)out.tab(1)).javadoc("\u67e5\u8be2\u5217\u8868", new Object[0]);
        ((JavaWriter)out.tab(1)).println("public <M> List<M> fetchList(ResultQuery<?> query, %s<M> clazz) {\n        return fetchList(query).into(clazz);\n    }", new Object[]{Class.class});
        ((JavaWriter)out.tab(1)).javadoc("\u67e5\u8be2\u5217\u8868", new Object[0]);
        ((JavaWriter)out.tab(1)).println("public <R extends %s> %s<R> fetchList(%s<R> query) {\n        return ctx().fetch(query);\n    }", new Object[]{Record.class, Result.class, ResultQuery.class});
    }
}

