/*
 * Decompiled with CFR 0.152.
 */
package pro.leaco.mybatis.generator.plugins;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import pro.leaco.mybatis.generator.plugins.utils.BasePlugin;
import pro.leaco.mybatis.generator.plugins.utils.FormatTools;

public class ConstructorBasedBugFixPlugin
extends BasePlugin {
    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String[] strs;
        String version;
        if (introspectedTable.isConstructorBased() && introspectedTable.hasBLOBColumns() && introspectedTable.getBLOBColumns().size() == 1 && (version = Plugin.class.getPackage().getImplementationVersion()) != null && (strs = version.split("\\.")).length == 3 && strs[0].equals("1") && strs[1].equals("3") && Integer.parseInt(strs[2]) < 6) {
            Method method = new Method(topLevelClass.getType().getShortName());
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setConstructor(true);
            this.commentGenerator.addGeneralMethodComment(method, introspectedTable);
            List constructorColumns = introspectedTable.getNonBLOBColumns();
            for (IntrospectedColumn introspectedColumn : constructorColumns) {
                method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), introspectedColumn.getJavaProperty()));
                topLevelClass.addImportedType(introspectedColumn.getFullyQualifiedJavaType());
            }
            StringBuilder sb = new StringBuilder();
            if (introspectedTable.getRules().generatePrimaryKeyClass()) {
                boolean comma = false;
                sb.append("super(");
                for (IntrospectedColumn introspectedColumn : introspectedTable.getPrimaryKeyColumns()) {
                    if (comma) {
                        sb.append(", ");
                    } else {
                        comma = true;
                    }
                    sb.append(introspectedColumn.getJavaProperty());
                }
                sb.append(");");
                method.addBodyLine(sb.toString());
            }
            List introspectedColumns = !introspectedTable.getRules().generatePrimaryKeyClass() && introspectedTable.hasPrimaryKeyColumns() ? introspectedTable.getNonBLOBColumns() : introspectedTable.getBaseColumns();
            for (IntrospectedColumn introspectedColumn : introspectedColumns) {
                sb.setLength(0);
                sb.append("this.");
                sb.append(introspectedColumn.getJavaProperty());
                sb.append(" = ");
                sb.append(introspectedColumn.getJavaProperty());
                sb.append(';');
                method.addBodyLine(sb.toString());
            }
            FormatTools.addMethodWithBestPosition(topLevelClass, method);
        }
        return true;
    }
}

