/*
 * Decompiled with CFR 0.152.
 */
package pro.leaco.mybatis.generator.plugins;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerInterface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import pro.leaco.mybatis.generator.plugins.ModelColumnPlugin;
import pro.leaco.mybatis.generator.plugins.utils.BasePlugin;
import pro.leaco.mybatis.generator.plugins.utils.FormatTools;
import pro.leaco.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import pro.leaco.mybatis.generator.plugins.utils.PluginTools;

public class ExampleEnhancedPlugin
extends BasePlugin {
    public static final String METHOD_NEW_AND_CREATE_CRITERIA = "newAndCreateCriteria";
    public static final String PRO_ENABLE_AND_IF = "enableAndIf";
    private boolean enableColumnOperate = false;

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
        this.enableColumnOperate = PluginTools.checkDependencyPlugin(this.context, ModelColumnPlugin.class);
        String enableAndIf = this.properties.getProperty(PRO_ENABLE_AND_IF);
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        List innerClasses = topLevelClass.getInnerClasses();
        for (int i = 0; i < innerClasses.size(); ++i) {
            InnerClass innerClass = (InnerClass)innerClasses.get(i);
            if ("Criteria".equals(innerClass.getType().getShortName())) {
                this.addFactoryMethodToCriteria(topLevelClass, innerClass, introspectedTable);
                this.addWhenToCriteria(topLevelClass, innerClass, introspectedTable);
                continue;
            }
            if (!"GeneratedCriteria".equals(innerClass.getType().getShortName())) continue;
            this.addCustomConditionMethodToCriteria(topLevelClass, innerClass, introspectedTable);
            if (!this.enableColumnOperate) continue;
            this.addColumnMethodToCriteria(topLevelClass, innerClass, introspectedTable);
        }
        List methods = topLevelClass.getMethods();
        for (Method method : methods) {
            if (!"createCriteriaInternal".equals(method.getName())) continue;
            method.getBodyLines().set(0, "Criteria criteria = new Criteria(this);");
            logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u4fee\u6539createCriteriaInternal\u65b9\u6cd5\uff0c\u4fee\u6539\u6784\u9020Criteria\u65f6\u4f20\u5165Example\u5bf9\u8c61");
        }
        this.addAddMethodToExample(topLevelClass, introspectedTable);
        this.addjoinFieldToExample(topLevelClass, introspectedTable);
        this.addJoinMethodToExample(topLevelClass, introspectedTable);
        this.addGroupByMethodToExample(topLevelClass, introspectedTable);
        this.addOrderByMethodToExample(topLevelClass, introspectedTable);
        this.addStaticCreateCriteriaMethodToExample(topLevelClass, introspectedTable);
        this.addWhenToExample(topLevelClass, introspectedTable);
        return true;
    }

    private void addjoinFieldToExample(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType joinCriteriaType = new FullyQualifiedJavaType("java.util.List<Object>");
        Field joinCriteria = new Field("joinCriteria", joinCriteriaType);
        joinCriteria.setVisibility(JavaVisibility.PROTECTED);
        this.commentGenerator.addFieldComment(joinCriteria, introspectedTable);
        topLevelClass.addField(joinCriteria);
        Method joinCriteriaMethod = JavaElementGeneratorTools.generateMethod("getJoinCriteria", false, JavaVisibility.PUBLIC, joinCriteriaType, new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(joinCriteriaMethod, introspectedTable);
        joinCriteriaMethod.addBodyLine("return this.joinCriteria;");
        FormatTools.addMethodWithBestPosition(topLevelClass, joinCriteriaMethod);
    }

    private void addAddMethodToExample(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Method joinCriteriaMethod = JavaElementGeneratorTools.generateMethod("andCriteria", false, JavaVisibility.PUBLIC, new FullyQualifiedJavaType(topLevelClass.getType().getShortName()), new Parameter(FullyQualifiedJavaType.getObjectInstance(), "criteria"));
        this.commentGenerator.addGeneralMethodComment(joinCriteriaMethod, introspectedTable);
        joinCriteriaMethod.addBodyLine("if(this.joinCriteria == null){");
        joinCriteriaMethod.addBodyLine("this.joinCriteria = new java.util.ArrayList<>();");
        joinCriteriaMethod.addBodyLine("}");
        joinCriteriaMethod.addBodyLine("this.joinCriteria.add(criteria);");
        joinCriteriaMethod.addBodyLine("return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, joinCriteriaMethod);
    }

    private void addStaticCreateCriteriaMethodToExample(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Method createCriteriaMethod = JavaElementGeneratorTools.generateMethod(METHOD_NEW_AND_CREATE_CRITERIA, false, JavaVisibility.PUBLIC, FullyQualifiedJavaType.getCriteriaInstance(), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(createCriteriaMethod, introspectedTable);
        createCriteriaMethod.setStatic(true);
        createCriteriaMethod.addBodyLine(topLevelClass.getType().getShortName() + " example = new " + topLevelClass.getType().getShortName() + "();");
        createCriteriaMethod.addBodyLine("return example.createCriteria();");
        FormatTools.addMethodWithBestPosition(topLevelClass, createCriteriaMethod);
    }

    private void addCustomConditionMethodToCriteria(TopLevelClass topLevelClass, InnerClass innerClass, IntrospectedTable introspectedTable) {
        FormatTools.addMethodWithBestPosition(innerClass, this.generateCustomConditionMethod());
        FormatTools.addMethodWithBestPosition(innerClass, this.generateCustomAndConditionMethod("andBetween", "between"));
        FormatTools.addMethodWithBestPosition(innerClass, this.generateCustomAndConditionMethod("andNotBetween", "not between"));
    }

    private Method generateCustomConditionMethod() {
        Method method = JavaElementGeneratorTools.generateMethod("and", false, JavaVisibility.PUBLIC, FullyQualifiedJavaType.getCriteriaInstance(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "sql", true));
        JavaElementGeneratorTools.generateMethodBody(method, "String condition = \"\";", "for (String s : sql) {", "condition += s + \" \";", "}", "addCriterion(condition);", "return (Criteria) this;");
        return method;
    }

    private Method generateCustomAndConditionMethod(String methodName, String condition) {
        Method method = JavaElementGeneratorTools.generateMethod(methodName, false, JavaVisibility.PUBLIC, FullyQualifiedJavaType.getCriteriaInstance(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "exp"), new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value1"), new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value2"));
        JavaElementGeneratorTools.generateMethodBody(method, "addCriterion(exp + \" " + condition + "\" , value1, value2, exp );", "return (Criteria) this;");
        return method;
    }

    private void addColumnMethodToCriteria(TopLevelClass topLevelClass, InnerClass innerClass, IntrospectedTable introspectedTable) {
        topLevelClass.addImportedType(introspectedTable.getRules().calculateAllFieldsClass());
        for (IntrospectedColumn introspectedColumn : introspectedTable.getNonBLOBColumns()) {
            topLevelClass.addImportedType(introspectedColumn.getFullyQualifiedJavaType());
            FormatTools.addMethodWithBestPosition(innerClass, this.generateSingleValueMethod(introspectedTable, introspectedColumn, "EqualTo", "="));
            FormatTools.addMethodWithBestPosition(innerClass, this.generateSingleValueMethod(introspectedTable, introspectedColumn, "NotEqualTo", "<>"));
            FormatTools.addMethodWithBestPosition(innerClass, this.generateSingleValueMethod(introspectedTable, introspectedColumn, "GreaterThan", ">"));
            FormatTools.addMethodWithBestPosition(innerClass, this.generateSingleValueMethod(introspectedTable, introspectedColumn, "GreaterThanOrEqualTo", ">="));
            FormatTools.addMethodWithBestPosition(innerClass, this.generateSingleValueMethod(introspectedTable, introspectedColumn, "LessThan", "<"));
            FormatTools.addMethodWithBestPosition(innerClass, this.generateSingleValueMethod(introspectedTable, introspectedColumn, "LessThanOrEqualTo", "<="));
        }
    }

    private Method generateSingleValueMethod(IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn, String nameFragment, String operator) {
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        sb.append(nameFragment);
        sb.append("Column");
        Method method = JavaElementGeneratorTools.generateMethod(sb.toString(), false, JavaVisibility.PUBLIC, FullyQualifiedJavaType.getCriteriaInstance(), new Parameter(new FullyQualifiedJavaType(introspectedTable.getRules().calculateAllFieldsClass().getShortName() + "." + "Column"), "column"));
        sb.setLength(0);
        sb.append("addCriterion(\"");
        sb.append(MyBatis3FormattingUtilities.getAliasedActualColumnName((IntrospectedColumn)introspectedColumn));
        sb.append(" ");
        sb.append(operator);
        sb.append(" \" + ");
        sb.append("column.");
        sb.append("getEscapedColumnName");
        sb.append("());");
        JavaElementGeneratorTools.generateMethodBody(method, sb.toString(), "return (Criteria) this;");
        return method;
    }

    private void addFactoryMethodToCriteria(TopLevelClass topLevelClass, InnerClass innerClass, IntrospectedTable introspectedTable) {
        Field exampleField = JavaElementGeneratorTools.generateField("example", JavaVisibility.PRIVATE, topLevelClass.getType(), null);
        this.commentGenerator.addFieldComment(exampleField, introspectedTable);
        innerClass.addField(exampleField);
        List methods = innerClass.getMethods();
        for (Method method : methods) {
            if (!method.isConstructor()) continue;
            method.addParameter(new Parameter(topLevelClass.getType(), "example"));
            method.addBodyLine("this.example = example;");
            this.commentGenerator.addGeneralMethodComment(method, introspectedTable);
            logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u4fee\u6539\u6784\u9020\u65b9\u6cd5\uff0c\u589e\u52a0example\u53c2\u6570");
        }
        Method exampleMethod = JavaElementGeneratorTools.generateMethod("example", false, JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(exampleMethod, introspectedTable);
        exampleMethod = JavaElementGeneratorTools.generateMethodBody(exampleMethod, "return this.example;");
        FormatTools.addMethodWithBestPosition(innerClass, exampleMethod);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "." + innerClass.getType().getShortName() + "\u589e\u52a0\u5de5\u5382\u65b9\u6cd5example");
    }

    private void addWhenToCriteria(TopLevelClass topLevelClass, InnerClass innerClass, IntrospectedTable introspectedTable) {
        this.addWhenToClass(topLevelClass, innerClass, introspectedTable, "criteria");
    }

    private void addWhenToExample(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addWhenToClass(topLevelClass, (InnerClass)topLevelClass, introspectedTable, "example");
    }

    private void addWhenToClass(TopLevelClass topLevelClass, InnerClass clazz, IntrospectedTable introspectedTable, String type) {
        InnerInterface whenInterface = new InnerInterface("I" + FormatTools.upFirstChar(type) + "When");
        whenInterface.setVisibility(JavaVisibility.PUBLIC);
        Method addMethod = JavaElementGeneratorTools.generateMethod(type, false, JavaVisibility.DEFAULT, null, new Parameter(clazz.getType(), type));
        this.commentGenerator.addGeneralMethodComment(addMethod, introspectedTable);
        addMethod.setAbstract(true);
        whenInterface.addMethod(addMethod);
        topLevelClass.addInnerInterface(whenInterface);
        Method whenMethod = JavaElementGeneratorTools.generateMethod("when", false, JavaVisibility.PUBLIC, clazz.getType(), new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "condition"), new Parameter(whenInterface.getType(), "then"));
        this.commentGenerator.addGeneralMethodComment(whenMethod, introspectedTable);
        whenMethod = JavaElementGeneratorTools.generateMethodBody(whenMethod, "if (condition) {", "then." + type + "(this);", "}", "return this;");
        FormatTools.addMethodWithBestPosition(clazz, whenMethod);
        Method whenOtherwiseMethod = JavaElementGeneratorTools.generateMethod("when", false, JavaVisibility.PUBLIC, clazz.getType(), new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "condition"), new Parameter(whenInterface.getType(), "then"), new Parameter(whenInterface.getType(), "otherwise"));
        this.commentGenerator.addGeneralMethodComment(whenOtherwiseMethod, introspectedTable);
        whenOtherwiseMethod = JavaElementGeneratorTools.generateMethodBody(whenOtherwiseMethod, "if (condition) {", "then." + type + "(this);", "} else {", "otherwise." + type + "(this);", "}", "return this;");
        FormatTools.addMethodWithBestPosition(clazz, whenOtherwiseMethod);
    }

    private void addJoinMethodToExample(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Field joinClauseField = JavaElementGeneratorTools.generateField("joinClause", JavaVisibility.PROTECTED, new FullyQualifiedJavaType("java.lang.String"), null);
        this.commentGenerator.addFieldComment(joinClauseField, introspectedTable);
        topLevelClass.addField(joinClauseField);
        Method getMethod = JavaElementGeneratorTools.generateMethod("getJoinClause", false, JavaVisibility.PUBLIC, new FullyQualifiedJavaType("java.lang.String"), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(getMethod, introspectedTable);
        getMethod = JavaElementGeneratorTools.generateMethodBody(getMethod, "return joinClause;");
        FormatTools.addMethodWithBestPosition(topLevelClass, getMethod);
        this.addJoinMethod("innerJoin", "INNER JOIN", topLevelClass, introspectedTable);
        this.addJoinMethod("leftJoin", "LEFT JOIN", topLevelClass, introspectedTable);
        this.addJoinMethod("rightJoin", "RIGHT JOIN", topLevelClass, introspectedTable);
    }

    private void addJoinMethod(String joinMethodName, String joinSql, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Method method1 = JavaElementGeneratorTools.generateMethod(joinMethodName, false, JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "table"), new Parameter(FullyQualifiedJavaType.getStringInstance(), "on", true));
        this.commentGenerator.addGeneralMethodComment(method1, introspectedTable);
        method1 = JavaElementGeneratorTools.generateMethodBody(method1, "StringBuffer sb = new StringBuffer();", "sb.append(\"" + joinSql + " \");", "sb.append(table);", "sb.append(\" ON \");", "for (int i = 0; i < on.length; i++) {", "sb.append(on[i]);", "if (i < on.length - 1) {", "sb.append(\" AND \");", "}", "}", "this.joinClause = sb.toString();", "return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, method1);
    }

    private void addGroupByMethodToExample(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Field groupByClauseField = JavaElementGeneratorTools.generateField("groupByClause", JavaVisibility.PROTECTED, new FullyQualifiedJavaType("java.lang.String"), null);
        this.commentGenerator.addFieldComment(groupByClauseField, introspectedTable);
        topLevelClass.addField(groupByClauseField);
        Method getMethod = JavaElementGeneratorTools.generateMethod("getGroupByClause", false, JavaVisibility.PUBLIC, new FullyQualifiedJavaType("java.lang.String"), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(getMethod, introspectedTable);
        getMethod = JavaElementGeneratorTools.generateMethodBody(getMethod, "return groupByClause;");
        FormatTools.addMethodWithBestPosition(topLevelClass, getMethod);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u65b9\u6cd5getGroupByClause");
        Method method = JavaElementGeneratorTools.generateMethod("groupBy", false, JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "groupByClause"));
        this.commentGenerator.addGeneralMethodComment(method, introspectedTable);
        method = JavaElementGeneratorTools.generateMethodBody(method, "this.groupByClause = groupByClause;", "return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, method);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u65b9\u6cd5groupBy");
        Method method1 = JavaElementGeneratorTools.generateMethod("groupBy", false, JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "groupByClause", true));
        this.commentGenerator.addGeneralMethodComment(method1, introspectedTable);
        method1 = JavaElementGeneratorTools.generateMethodBody(method1, "StringBuffer sb = new StringBuffer();", "for (int i = 0; i < groupByClause.length; i++) {", "sb.append(groupByClause[i]);", "if (i < groupByClause.length - 1) {", "sb.append(\" , \");", "}", "}", "this.groupByClause = sb.toString();", "return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, method1);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u65b9\u6cd5groupBy(String ... groupByClause)");
    }

    private void addOrderByMethodToExample(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Method orderByMethod = JavaElementGeneratorTools.generateMethod("orderBy", false, JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "orderByClause"));
        this.commentGenerator.addGeneralMethodComment(orderByMethod, introspectedTable);
        orderByMethod = JavaElementGeneratorTools.generateMethodBody(orderByMethod, "this.setOrderByClause(orderByClause);", "return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, orderByMethod);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u65b9\u6cd5orderBy");
        Method orderByMethod1 = JavaElementGeneratorTools.generateMethod("orderBy", false, JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "orderByClauses", true));
        this.commentGenerator.addGeneralMethodComment(orderByMethod1, introspectedTable);
        orderByMethod1 = JavaElementGeneratorTools.generateMethodBody(orderByMethod1, "StringBuffer sb = new StringBuffer();", "for (int i = 0; i < orderByClauses.length; i++) {", "sb.append(orderByClauses[i]);", "if (i < orderByClauses.length - 1) {", "sb.append(\" , \");", "}", "}", "this.setOrderByClause(sb.toString());", "return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, orderByMethod1);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u65b9\u6cd5orderBy(String ... orderByClauses)");
    }
}

