/*
 * Decompiled with CFR 0.152.
 */
package pro.leaco.mybatis.generator.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.StringUtility;
import pro.leaco.mybatis.generator.plugins.ModelBuilderPlugin;
import pro.leaco.mybatis.generator.plugins.utils.BasePlugin;
import pro.leaco.mybatis.generator.plugins.utils.EnumModelType;
import pro.leaco.mybatis.generator.plugins.utils.PluginTools;
import pro.leaco.mybatis.generator.plugins.utils.hook.ILombokPluginHook;

public class LombokPlugin
extends BasePlugin {
    public static final String PRO_SUPPORT_SUPER_BUILDER_FOR_IDEA = "supportSuperBuilderForIdea";
    private static final List<String> LOMBOK_FEATURES;
    private static final List<String> LOMBOK_EXPERIMENTAL_FEATURES;
    private static final Pattern LOMBOK_ANNOTATION;
    private List<String> annotations;
    private boolean suportSuperBuilderForIdea;

    @Override
    public boolean validate(List<String> warnings) {
        Properties properties = this.getProperties();
        for (Object key : properties.keySet()) {
            String annotation = key.toString().trim();
            if (annotation.matches(LOMBOK_ANNOTATION.pattern()) || PRO_SUPPORT_SUPER_BUILDER_FOR_IDEA.equals(annotation)) continue;
            warnings.add("itfsw:\u63d2\u4ef6" + LombokPlugin.class.getTypeName() + "\u4e0d\u80fd\u8bc6\u522b\u7684\u6ce8\u89e3\uff08" + annotation + "\uff09\uff01");
            return false;
        }
        return super.validate(warnings);
    }

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
        this.annotations = new ArrayList<String>();
        Properties properties = this.getProperties();
        boolean findData = false;
        for (Object key : properties.keySet()) {
            String annotation = key.toString().trim();
            if (annotation.startsWith("@Data")) {
                findData = true;
            }
            if (!StringUtility.isTrue((String)properties.getProperty(key.toString())) || PRO_SUPPORT_SUPER_BUILDER_FOR_IDEA.equals(annotation)) continue;
            this.annotations.add(annotation);
        }
        if (!findData) {
            this.annotations.add(0, "@Data");
        }
        this.suportSuperBuilderForIdea = StringUtility.isTrue((String)properties.getProperty(PRO_SUPPORT_SUPER_BUILDER_FOR_IDEA));
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addAnnotations(topLevelClass, introspectedTable, EnumModelType.MODEL_BASE_RECORD);
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addAnnotations(topLevelClass, introspectedTable, EnumModelType.MODEL_PRIMARY_KEY);
        return super.modelPrimaryKeyClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addAnnotations(topLevelClass, introspectedTable, EnumModelType.MODEL_RECORD_WITH_BLOBS);
        return super.modelRecordWithBLOBsClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        for (String annotation : this.annotations) {
            if (!annotation.startsWith("@Data") && !annotation.startsWith("@Getter")) continue;
            return false;
        }
        return true;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        for (String annotation : this.annotations) {
            if (!annotation.startsWith("@Data") && !annotation.startsWith("@Setter")) continue;
            return false;
        }
        return true;
    }

    private void addAnnotations(TopLevelClass topLevelClass, IntrospectedTable introspectedTable, EnumModelType modelType) {
        for (String annotation : this.annotations) {
            if (annotation.startsWith("@Data")) {
                this.addAnnotation(topLevelClass, annotation);
                if (!topLevelClass.getSuperClass().isPresent()) continue;
                this.addAnnotation(topLevelClass, "@EqualsAndHashCode(callSuper = true)");
                this.addAnnotation(topLevelClass, "@ToString(callSuper = true)");
                continue;
            }
            if (annotation.startsWith("@Builder")) {
                boolean checkIncrementsPlugin = true;
                if (!this.suportSuperBuilderForIdea) {
                    switch (modelType) {
                        case MODEL_PRIMARY_KEY: {
                            checkIncrementsPlugin = PluginTools.getHook(ILombokPluginHook.class).modelPrimaryKeyBuilderClassGenerated(topLevelClass, introspectedTable);
                            break;
                        }
                        case MODEL_BASE_RECORD: {
                            checkIncrementsPlugin = PluginTools.getHook(ILombokPluginHook.class).modelBaseRecordBuilderClassGenerated(topLevelClass, introspectedTable);
                            break;
                        }
                        case MODEL_RECORD_WITH_BLOBS: {
                            checkIncrementsPlugin = PluginTools.getHook(ILombokPluginHook.class).modelRecordWithBLOBsBuilderClassGenerated(topLevelClass, introspectedTable);
                        }
                    }
                }
                if (!checkIncrementsPlugin) continue;
                int count = 0;
                if (introspectedTable.getRules().generatePrimaryKeyClass()) {
                    ++count;
                }
                if (introspectedTable.getRules().generateBaseRecordClass()) {
                    ++count;
                }
                if (introspectedTable.getRules().generateRecordWithBLOBsClass()) {
                    ++count;
                }
                if (topLevelClass.getSuperClass() != null || count >= 2) {
                    if (this.suportSuperBuilderForIdea) {
                        PluginConfiguration configuration = new PluginConfiguration();
                        configuration.setConfigurationType(ModelBuilderPlugin.class.getTypeName());
                        ModelBuilderPlugin modelBuilderPlugin = (ModelBuilderPlugin)ObjectFactory.createPlugin((Context)this.context, (PluginConfiguration)configuration);
                        switch (modelType) {
                            case MODEL_PRIMARY_KEY: {
                                modelBuilderPlugin.modelPrimaryKeyBuilderClassGenerated(topLevelClass, introspectedTable);
                                break;
                            }
                            case MODEL_BASE_RECORD: {
                                modelBuilderPlugin.modelBaseRecordBuilderClassGenerated(topLevelClass, introspectedTable);
                                break;
                            }
                            case MODEL_RECORD_WITH_BLOBS: {
                                modelBuilderPlugin.modelRecordWithBLOBsBuilderClassGenerated(topLevelClass, introspectedTable);
                            }
                        }
                        continue;
                    }
                    this.addAnnotation(topLevelClass, "@SuperBuilder");
                    continue;
                }
                this.addAnnotation(topLevelClass, annotation);
                continue;
            }
            this.addAnnotation(topLevelClass, annotation);
        }
    }

    private void addAnnotation(TopLevelClass topLevelClass, String annotation) {
        Matcher matcher = LOMBOK_ANNOTATION.matcher(annotation);
        if (matcher.find()) {
            String annotationName = matcher.group(1);
            if (LOMBOK_FEATURES.contains(annotationName)) {
                topLevelClass.addImportedType("lombok." + annotationName);
            } else if (LOMBOK_EXPERIMENTAL_FEATURES.contains(annotationName)) {
                topLevelClass.addImportedType("lombok.experimental." + annotationName);
            } else {
                this.warnings.add("itfsw:\u63d2\u4ef6" + LombokPlugin.class.getTypeName() + "\u6ca1\u6709\u627e\u5230\u6ce8\u89e3\uff08" + annotation + "\uff09\uff01");
                return;
            }
            topLevelClass.addAnnotation(annotation);
        }
    }

    static {
        LOMBOK_ANNOTATION = Pattern.compile("@([a-zA-z]+)(\\(.*\\))?");
        LOMBOK_FEATURES = Arrays.asList("Getter", "Setter", "ToString", "EqualsAndHashCode", "NoArgsConstructor", "RequiredArgsConstructor", "AllArgsConstructor", "Data", "Value", "Builder", "Log");
        LOMBOK_EXPERIMENTAL_FEATURES = Arrays.asList("Accessors", "FieldDefaults", "Wither", "UtilityClass", "Helper", "FieldNameConstants", "SuperBuilder");
    }
}

