/*
 * Decompiled with CFR 0.152.
 */
package pro.leaco.mybatis.generator.plugins;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import pro.leaco.mybatis.generator.plugins.utils.BasePlugin;
import pro.leaco.mybatis.generator.plugins.utils.FormatTools;
import pro.leaco.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import pro.leaco.mybatis.generator.plugins.utils.PluginTools;
import pro.leaco.mybatis.generator.plugins.utils.enhanced.InnerTypeFullyQualifiedJavaType;
import pro.leaco.mybatis.generator.plugins.utils.hook.ILombokPluginHook;
import pro.leaco.mybatis.generator.plugins.utils.hook.IModelBuilderPluginHook;

public class ModelBuilderPlugin
extends BasePlugin
implements ILombokPluginHook {
    public static final String BUILDER_CLASS_NAME = "Builder";

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        List columns = introspectedTable.getRules().generateRecordWithBLOBsClass() ? introspectedTable.getNonBLOBColumns() : introspectedTable.getAllColumns();
        InnerClass innerClass = this.generateModelBuilder(topLevelClass, introspectedTable, columns);
        topLevelClass.addInnerClass(innerClass);
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        InnerClass innerClass = this.generateModelBuilder(topLevelClass, introspectedTable, introspectedTable.getAllColumns());
        topLevelClass.addInnerClass(innerClass);
        return super.modelRecordWithBLOBsClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        InnerClass innerClass = this.generateModelBuilder(topLevelClass, introspectedTable, introspectedTable.getPrimaryKeyColumns());
        topLevelClass.addInnerClass(innerClass);
        return super.modelPrimaryKeyClassGenerated(topLevelClass, introspectedTable);
    }

    @Override
    public boolean modelBaseRecordBuilderClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        List columns = introspectedTable.getRules().generateRecordWithBLOBsClass() ? introspectedTable.getNonBLOBColumns() : introspectedTable.getAllColumns();
        InnerClass innerClass = this.generateModelBuilder(topLevelClass, introspectedTable, columns);
        topLevelClass.addInnerClass(innerClass);
        return true;
    }

    @Override
    public boolean modelPrimaryKeyBuilderClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        InnerClass innerClass = this.generateModelBuilder(topLevelClass, introspectedTable, introspectedTable.getPrimaryKeyColumns());
        topLevelClass.addInnerClass(innerClass);
        return true;
    }

    @Override
    public boolean modelRecordWithBLOBsBuilderClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        InnerClass innerClass = this.generateModelBuilder(topLevelClass, introspectedTable, introspectedTable.getAllColumns());
        topLevelClass.addInnerClass(innerClass);
        return true;
    }

    private InnerClass generateModelBuilder(TopLevelClass topLevelClass, IntrospectedTable introspectedTable, List<IntrospectedColumn> columns) {
        InnerClass innerClass = new InnerClass(BUILDER_CLASS_NAME);
        innerClass.setVisibility(JavaVisibility.PUBLIC);
        innerClass.setStatic(true);
        if (topLevelClass.getSuperClass().isPresent()) {
            innerClass.setSuperClass(((FullyQualifiedJavaType)topLevelClass.getSuperClass().get()).getShortName() + "." + BUILDER_CLASS_NAME);
        }
        InnerTypeFullyQualifiedJavaType builderType = new InnerTypeFullyQualifiedJavaType(topLevelClass.getType().getFullyQualifiedName() + "." + BUILDER_CLASS_NAME);
        Method builder = JavaElementGeneratorTools.generateMethod("builder", false, JavaVisibility.PUBLIC, builderType, new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(builder, introspectedTable);
        builder.setStatic(true);
        builder.addBodyLine("return new " + builderType.getShortName() + "();");
        FormatTools.addMethodWithBestPosition(topLevelClass, builder);
        this.commentGenerator.addClassComment(innerClass, introspectedTable);
        logger.debug("itfsw(\u6570\u636eModel\u94fe\u5f0f\u6784\u5efa\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u5185\u90e8Builder\u7c7b\u3002");
        Field f = JavaElementGeneratorTools.generateField("obj", JavaVisibility.PRIVATE, topLevelClass.getType(), null);
        this.commentGenerator.addFieldComment(f, introspectedTable);
        innerClass.addField(f);
        Method constructor = new Method(BUILDER_CLASS_NAME);
        constructor.setVisibility(JavaVisibility.PUBLIC);
        constructor.setConstructor(true);
        constructor.addBodyLine("this.obj = new " + topLevelClass.getType().getShortName() + "();");
        this.commentGenerator.addGeneralMethodComment(constructor, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerClass, constructor);
        logger.debug("itfsw(\u6570\u636eModel\u94fe\u5f0f\u6784\u5efa\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Builder\u589e\u52a0\u7684\u6784\u9020\u65b9\u6cd5\u3002");
        for (IntrospectedColumn introspectedColumn : columns) {
            Field field = JavaBeansUtil.getJavaBeansField((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)introspectedTable);
            Method setterMethod = JavaBeansUtil.getJavaBeansSetter((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)introspectedTable);
            Method method = JavaElementGeneratorTools.generateMethod(field.getName(), false, JavaVisibility.PUBLIC, innerClass.getType(), new Parameter(field.getType(), field.getName()));
            this.commentGenerator.addSetterComment(method, introspectedTable, introspectedColumn);
            method = JavaElementGeneratorTools.generateMethodBody(method, "obj." + setterMethod.getName() + "(" + field.getName() + ");", "return this;");
            if (!PluginTools.getHook(IModelBuilderPluginHook.class).modelBuilderSetterMethodGenerated(method, topLevelClass, innerClass, introspectedColumn, introspectedTable)) continue;
            FormatTools.addMethodWithBestPosition(innerClass, method);
            logger.debug("itfsw(\u6570\u636eModel\u94fe\u5f0f\u6784\u5efa\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Builder\u589e\u52a0" + method.getName() + "\u65b9\u6cd5(\u590d\u5408\u4e3b\u952e)\u3002");
        }
        Method build = JavaElementGeneratorTools.generateMethod("build", false, JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter[0]);
        build.addBodyLine("return this.obj;");
        this.commentGenerator.addGeneralMethodComment(build, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerClass, build);
        logger.debug("itfsw(\u6570\u636eModel\u94fe\u5f0f\u6784\u5efa\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Builder\u589e\u52a0build\u65b9\u6cd5\u3002");
        PluginTools.getHook(IModelBuilderPluginHook.class).modelBuilderClassGenerated(topLevelClass, innerClass, columns, introspectedTable);
        return innerClass;
    }
}

