/*
 * Decompiled with CFR 0.152.
 */
package pro.leaco.mybatis.generator.plugins;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;
import pro.leaco.mybatis.generator.plugins.utils.BasePlugin;
import pro.leaco.mybatis.generator.plugins.utils.FormatTools;
import pro.leaco.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import pro.leaco.mybatis.generator.plugins.utils.PluginTools;
import pro.leaco.mybatis.generator.plugins.utils.hook.IModelColumnPluginHook;

public class ModelColumnPlugin
extends BasePlugin {
    public static final String ENUM_NAME = "Column";
    public static final String METHOD_EXCLUDES = "excludes";
    public static final String METHOD_ALL = "all";
    public static final String METHOD_AS = "as";
    public static final String METHOD_GET_ESCAPED_COLUMN_NAME = "getEscapedColumnName";
    public static final String METHOD_GET_ALIASED_ESCAPED_COLUMN_NAME = "getAliasedEscapedColumnName";
    public static final String CONST_BEGINNING_DELIMITER = "BEGINNING_DELIMITER";
    public static final String CONST_ENDING_DELIMITER = "ENDING_DELIMITER";

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Field field = new Field("TABLE", FullyQualifiedJavaType.getStringInstance());
        field.setStatic(true);
        field.setVisibility(JavaVisibility.PUBLIC);
        field.setInitializationString("\"" + introspectedTable.getTableConfiguration().getTableName() + "\"");
        this.commentGenerator.addFieldComment(field, introspectedTable);
        topLevelClass.addField(field);
        topLevelClass.addInnerEnum(this.generateColumnEnum(topLevelClass, introspectedTable));
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.addInnerEnum(this.generateColumnEnum(topLevelClass, introspectedTable));
        return super.modelRecordWithBLOBsClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.addInnerEnum(this.generateColumnEnum(topLevelClass, introspectedTable));
        return super.modelPrimaryKeyClassGenerated(topLevelClass, introspectedTable);
    }

    private InnerEnum generateColumnEnum(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String TABLE_NAME = introspectedTable.getTableConfiguration().getTableName();
        InnerEnum innerEnum = new InnerEnum(new FullyQualifiedJavaType(ENUM_NAME));
        innerEnum.setVisibility(JavaVisibility.PUBLIC);
        innerEnum.setStatic(true);
        this.commentGenerator.addEnumComment(innerEnum, introspectedTable);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u5185\u90e8Builder\u7c7b\u3002");
        Field beginningDelimiterField = JavaElementGeneratorTools.generateField(CONST_BEGINNING_DELIMITER, JavaVisibility.PRIVATE, FullyQualifiedJavaType.getStringInstance(), "\"" + StringUtility.escapeStringForJava((String)this.context.getBeginningDelimiter()) + "\"");
        beginningDelimiterField.setStatic(true);
        beginningDelimiterField.setFinal(true);
        this.commentGenerator.addFieldComment(beginningDelimiterField, introspectedTable);
        innerEnum.addField(beginningDelimiterField);
        Field endingDelimiterField = JavaElementGeneratorTools.generateField(CONST_ENDING_DELIMITER, JavaVisibility.PRIVATE, FullyQualifiedJavaType.getStringInstance(), "\"" + StringUtility.escapeStringForJava((String)this.context.getEndingDelimiter()) + "\"");
        endingDelimiterField.setStatic(true);
        endingDelimiterField.setFinal(true);
        this.commentGenerator.addFieldComment(endingDelimiterField, introspectedTable);
        innerEnum.addField(endingDelimiterField);
        Field columnField = new Field("column", FullyQualifiedJavaType.getStringInstance());
        columnField.setVisibility(JavaVisibility.PRIVATE);
        columnField.setFinal(true);
        this.commentGenerator.addFieldComment(columnField, introspectedTable);
        innerEnum.addField(columnField);
        Field isColumnNameDelimitedField = new Field("isColumnNameDelimited", FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        isColumnNameDelimitedField.setVisibility(JavaVisibility.PRIVATE);
        isColumnNameDelimitedField.setFinal(true);
        this.commentGenerator.addFieldComment(isColumnNameDelimitedField, introspectedTable);
        innerEnum.addField(isColumnNameDelimitedField);
        Field javaPropertyField = new Field("javaProperty", FullyQualifiedJavaType.getStringInstance());
        javaPropertyField.setVisibility(JavaVisibility.PRIVATE);
        javaPropertyField.setFinal(true);
        this.commentGenerator.addFieldComment(javaPropertyField, introspectedTable);
        innerEnum.addField(javaPropertyField);
        Field jdbcTypeField = new Field("jdbcType", FullyQualifiedJavaType.getStringInstance());
        jdbcTypeField.setVisibility(JavaVisibility.PRIVATE);
        jdbcTypeField.setFinal(true);
        this.commentGenerator.addFieldComment(jdbcTypeField, introspectedTable);
        innerEnum.addField(jdbcTypeField);
        Method mValue = new Method("value");
        mValue.setVisibility(JavaVisibility.PUBLIC);
        mValue.setReturnType(FullyQualifiedJavaType.getStringInstance());
        mValue.addBodyLine("return this.column;");
        this.commentGenerator.addGeneralMethodComment(mValue, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, mValue);
        Method mGetValue = new Method("getValue");
        mGetValue.setVisibility(JavaVisibility.PUBLIC);
        mGetValue.setReturnType(FullyQualifiedJavaType.getStringInstance());
        mGetValue.addBodyLine("return this.column;");
        this.commentGenerator.addGeneralMethodComment(mGetValue, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, mGetValue);
        Method mGetJavaProperty = JavaElementGeneratorTools.generateGetterMethod(javaPropertyField);
        this.commentGenerator.addGeneralMethodComment(mGetJavaProperty, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, mGetJavaProperty);
        Method mGetJdbcType = JavaElementGeneratorTools.generateGetterMethod(jdbcTypeField);
        this.commentGenerator.addGeneralMethodComment(mGetJdbcType, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, mGetJdbcType);
        Method constructor = new Method(ENUM_NAME);
        constructor.setConstructor(true);
        constructor.addBodyLine("this.column = column;");
        constructor.addBodyLine("this.javaProperty = javaProperty;");
        constructor.addBodyLine("this.jdbcType = jdbcType;");
        constructor.addBodyLine("this.isColumnNameDelimited = isColumnNameDelimited;");
        constructor.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "column"));
        constructor.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "javaProperty"));
        constructor.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "jdbcType"));
        constructor.addParameter(new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "isColumnNameDelimited"));
        this.commentGenerator.addGeneralMethodComment(constructor, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, constructor);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0\u6784\u9020\u65b9\u6cd5\u548ccolumn\u5c5e\u6027\u3002");
        for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {
            Field field = JavaBeansUtil.getJavaBeansField((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)introspectedTable);
            StringBuffer sb = new StringBuffer();
            sb.append(field.getName());
            sb.append("(\"");
            sb.append(introspectedColumn.getActualColumnName());
            sb.append("\", \"");
            sb.append(introspectedColumn.getJavaProperty());
            sb.append("\", \"");
            sb.append(introspectedColumn.getJdbcTypeName());
            sb.append("\", ");
            sb.append(introspectedColumn.isColumnNameDelimited());
            sb.append(")");
            innerEnum.addEnumConstant(sb.toString());
            logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0" + field.getName() + "\u679a\u4e3e\u3002");
        }
        Method desc = new Method("desc");
        desc.setVisibility(JavaVisibility.PUBLIC);
        desc.setReturnType(FullyQualifiedJavaType.getStringInstance());
        desc.addBodyLine("return this.getEscapedColumnName() + \" DESC\";");
        this.commentGenerator.addGeneralMethodComment(desc, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, desc);
        Method asc = new Method("asc");
        asc.setVisibility(JavaVisibility.PUBLIC);
        asc.setReturnType(FullyQualifiedJavaType.getStringInstance());
        asc.addBodyLine("return this.getEscapedColumnName() + \" ASC\";");
        this.commentGenerator.addGeneralMethodComment(asc, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, asc);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0asc()\u548cdesc()\u65b9\u6cd5\u3002");
        Method mAs = new Method(METHOD_AS);
        mAs.setVisibility(JavaVisibility.PUBLIC);
        mAs.setReturnType(FullyQualifiedJavaType.getStringInstance());
        mAs.addBodyLine("return this.getEscapedColumnName() + \" AS \" + this.javaProperty;");
        this.commentGenerator.addGeneralMethodComment(mAs, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, mAs);
        Method mAs1 = new Method(METHOD_AS);
        mAs1.setVisibility(JavaVisibility.PUBLIC);
        mAs1.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "alias"));
        mAs1.setReturnType(FullyQualifiedJavaType.getStringInstance());
        mAs1.addBodyLine("return this.getEscapedColumnName() + \" AS \" + alias;");
        this.commentGenerator.addGeneralMethodComment(mAs1, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, mAs1);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0as(string)\u65b9\u6cd5\u3002");
        this.addMysqlFunctionWrapper("count", "COUNT", null, topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("sum", "SUM", null, topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("year", "YEAR", null, topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("firstDayOfYear", "DATE_FORMAT(DATE_SUB", "INTERVAL DAYOFYEAR(\" + this.getEscapedColumnName() + \")-1 DAY) ,'%Y-%m-%d'", topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("quarter", "QUARTER", null, topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("month", "MONTH", null, topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("firstDayOfMonth", "DATE_FORMAT(DATE_SUB", "INTERVAL DAY(\" + this.getEscapedColumnName() + \")-1 DAY) ,'%Y-%m-%d'", topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("yearWeekMondayFirst", "YEARWEEK(date_format", "'%Y-%m-%d'),1", topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("firstDayOfWeek", "DATE_FORMAT(DATE_ADD", "INTERVAL -WEEKDAY(\" + this.getEscapedColumnName() + \") DAY) ,'%Y-%m-%d'", topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("day", "DAY", null, topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("toDays", "TO_DAYS", null, topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("dateFormatWith$yyyyMMdd$", "DATE_FORMAT", "\\\"%Y-%m-%d\\\"", topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("dateFormatWith$yyyyMMddHHmmss$", "DATE_FORMAT", "\\\"%Y-%m-%d %T\\\"", topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("dateFormat", "DATE_FORMAT", "pattern", true, topLevelClass, introspectedTable, innerEnum);
        this.addMysqlFunctionWrapper("dateSub", "DATE_SUB", "param", false, topLevelClass, introspectedTable, innerEnum);
        topLevelClass.addImportedType("java.util.Arrays");
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewArrayListInstance());
        Method mExcludes = JavaElementGeneratorTools.generateMethod(METHOD_EXCLUDES, false, JavaVisibility.PUBLIC, new FullyQualifiedJavaType("Column[]"), new Parameter(innerEnum.getType(), METHOD_EXCLUDES, true));
        this.commentGenerator.addGeneralMethodComment(mExcludes, introspectedTable);
        mExcludes.setStatic(true);
        JavaElementGeneratorTools.generateMethodBody(mExcludes, "ArrayList<Column> columns = new ArrayList<>(Arrays.asList(Column.values()));", "if (excludes != null && excludes.length > 0) {", "columns.removeAll(new ArrayList<>(Arrays.asList(excludes)));", "}", "return columns.toArray(new Column[]{});");
        FormatTools.addMethodWithBestPosition(innerEnum, mExcludes);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0excludes\u65b9\u6cd5\u3002");
        Method mAll = JavaElementGeneratorTools.generateMethod(METHOD_ALL, false, JavaVisibility.PUBLIC, new FullyQualifiedJavaType("Column[]"), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(mAll, introspectedTable);
        mAll.setStatic(true);
        mAll.addBodyLine("return Column.values();");
        FormatTools.addMethodWithBestPosition(innerEnum, mAll);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0all\u65b9\u6cd5\u3002");
        Method mGetAliasame = JavaElementGeneratorTools.generateMethod("withAlias", false, JavaVisibility.PUBLIC, FullyQualifiedJavaType.getStringInstance(), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(mGetAliasame, introspectedTable);
        JavaElementGeneratorTools.generateMethodBody(mGetAliasame, "if (this.isColumnNameDelimited) {", "return \"" + TABLE_NAME + ".\" + " + CONST_BEGINNING_DELIMITER + " + this.column + " + CONST_ENDING_DELIMITER + ";", "} else {", "return \"" + TABLE_NAME + ".\" + this.column;", "}");
        FormatTools.addMethodWithBestPosition(innerEnum, mGetAliasame);
        Method mGetAliasAs = JavaElementGeneratorTools.generateMethod("withAlias", false, JavaVisibility.PUBLIC, FullyQualifiedJavaType.getStringInstance(), new Parameter(FullyQualifiedJavaType.getStringInstance(), METHOD_AS));
        this.commentGenerator.addGeneralMethodComment(mGetAliasAs, introspectedTable);
        JavaElementGeneratorTools.generateMethodBody(mGetAliasAs, "if (this.isColumnNameDelimited) {", "return \"" + TABLE_NAME + ".\" + " + CONST_BEGINNING_DELIMITER + " + this.column + " + CONST_ENDING_DELIMITER + " + \" as \" + as;", "} else {", "return \"" + TABLE_NAME + ".\" + this.column + \" as \" + as;", "}");
        FormatTools.addMethodWithBestPosition(innerEnum, mGetAliasAs);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0 alias \u65b9\u6cd5\u3002");
        Method mGetEscapedColumnName = JavaElementGeneratorTools.generateMethod(METHOD_GET_ESCAPED_COLUMN_NAME, false, JavaVisibility.PUBLIC, FullyQualifiedJavaType.getStringInstance(), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(mGetEscapedColumnName, introspectedTable);
        JavaElementGeneratorTools.generateMethodBody(mGetEscapedColumnName, "if (this.isColumnNameDelimited) {", "return BEGINNING_DELIMITER + this.column + ENDING_DELIMITER;", "} else {", "return this.column;", "}");
        FormatTools.addMethodWithBestPosition(innerEnum, mGetEscapedColumnName);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0getEscapedColumnName\u65b9\u6cd5\u3002");
        Method mGetAliasedEscapedColumnName = JavaElementGeneratorTools.generateMethod(METHOD_GET_ALIASED_ESCAPED_COLUMN_NAME, false, JavaVisibility.PUBLIC, FullyQualifiedJavaType.getStringInstance(), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(mGetAliasedEscapedColumnName, introspectedTable);
        if (StringUtility.stringHasValue((String)introspectedTable.getTableConfiguration().getAlias())) {
            String alias = introspectedTable.getTableConfiguration().getAlias();
            mGetAliasedEscapedColumnName.addBodyLine("StringBuilder sb = new StringBuilder();");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(\"" + alias + ".\");");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(this.getEscapedColumnName());");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(\" as \");");
            mGetAliasedEscapedColumnName.addBodyLine("if (this.isColumnNameDelimited) {");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(BEGINNING_DELIMITER);");
            mGetAliasedEscapedColumnName.addBodyLine("}");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(\"" + alias + "_\");");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(this.column);");
            mGetAliasedEscapedColumnName.addBodyLine("if (this.isColumnNameDelimited) {");
            mGetAliasedEscapedColumnName.addBodyLine("sb.append(BEGINNING_DELIMITER);");
            mGetAliasedEscapedColumnName.addBodyLine("}");
            mGetAliasedEscapedColumnName.addBodyLine("return sb.toString();");
        } else {
            mGetAliasedEscapedColumnName.addBodyLine("return this.getEscapedColumnName();");
        }
        FormatTools.addMethodWithBestPosition(innerEnum, mGetAliasedEscapedColumnName);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0getAliasedEscapedColumnName\u65b9\u6cd5\u3002");
        PluginTools.getHook(IModelColumnPluginHook.class).modelColumnEnumGenerated(innerEnum, topLevelClass, introspectedTable);
        return innerEnum;
    }

    private void addMysqlFunctionWrapper(String methodName, String mysqlFunctionName, String mysqlFunctionInitParam, TopLevelClass topLevelClass, IntrospectedTable introspectedTable, InnerEnum innerEnum) {
        String body = "return \"" + mysqlFunctionName + "(\" + this." + METHOD_GET_ESCAPED_COLUMN_NAME + "() + \"" + (mysqlFunctionInitParam != null ? " , " + mysqlFunctionInitParam : "") + ")";
        Method m = new Method(methodName);
        m.setVisibility(JavaVisibility.PUBLIC);
        m.setReturnType(FullyQualifiedJavaType.getStringInstance());
        m.addBodyLine(body + "\";");
        this.commentGenerator.addGeneralMethodComment(m, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, m);
        Method m1 = new Method(methodName + "As");
        m1.setVisibility(JavaVisibility.PUBLIC);
        m1.setReturnType(FullyQualifiedJavaType.getStringInstance());
        m1.addBodyLine(body + " AS \" + this.getJavaProperty();");
        this.commentGenerator.addGeneralMethodComment(m1, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, m1);
        Method m2 = new Method(methodName + "As");
        m2.setVisibility(JavaVisibility.PUBLIC);
        m2.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "alias"));
        m2.setReturnType(FullyQualifiedJavaType.getStringInstance());
        m2.addBodyLine(body + " AS \" + alias;");
        this.commentGenerator.addGeneralMethodComment(m2, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, m2);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0" + mysqlFunctionName + "()\u65b9\u6cd5\u3002");
    }

    private void addMysqlFunctionWrapper(String methodName, String mysqlFunctionName, String mysqlFunctionParamName, boolean withQuot, TopLevelClass topLevelClass, IntrospectedTable introspectedTable, InnerEnum innerEnum) {
        String body = "return \"" + mysqlFunctionName + "(\" + this." + METHOD_GET_ESCAPED_COLUMN_NAME + "() + \" , ";
        if (withQuot) {
            body = body + "\\\"";
        }
        body = body + "\" + " + mysqlFunctionParamName + " + \"";
        if (withQuot) {
            body = body + "\\\"";
        }
        body = body + ")";
        Method m = new Method(methodName);
        m.setVisibility(JavaVisibility.PUBLIC);
        m.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), mysqlFunctionParamName));
        m.setReturnType(FullyQualifiedJavaType.getStringInstance());
        m.addBodyLine(body + "\";");
        this.commentGenerator.addGeneralMethodComment(m, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, m);
        Method m1 = new Method(methodName + "As");
        m1.setVisibility(JavaVisibility.PUBLIC);
        m1.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), mysqlFunctionParamName));
        m1.setReturnType(FullyQualifiedJavaType.getStringInstance());
        m1.addBodyLine(body + " AS \" + this.getJavaProperty();");
        this.commentGenerator.addGeneralMethodComment(m1, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, m1);
        Method m2 = new Method(methodName + "As");
        m2.setVisibility(JavaVisibility.PUBLIC);
        m2.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), mysqlFunctionParamName));
        m2.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "alias"));
        m2.setReturnType(FullyQualifiedJavaType.getStringInstance());
        m2.addBodyLine(body + " AS \" + alias;");
        this.commentGenerator.addGeneralMethodComment(m2, introspectedTable);
        FormatTools.addMethodWithBestPosition(innerEnum, m2);
        logger.debug("itfsw(\u6570\u636eModel\u5c5e\u6027\u5bf9\u5e94Column\u83b7\u53d6\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + ".Column\u589e\u52a0" + mysqlFunctionName + "()\u65b9\u6cd5\u3002");
    }
}

