/*
 * Decompiled with CFR 0.152.
 */
package pro.leaco.mybatis.generator.plugins;

import java.util.List;
import java.util.function.Supplier;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;
import pro.leaco.mybatis.generator.plugins.ModelColumnPlugin;
import pro.leaco.mybatis.generator.plugins.utils.BasePlugin;
import pro.leaco.mybatis.generator.plugins.utils.FormatTools;
import pro.leaco.mybatis.generator.plugins.utils.JavaElementTools;
import pro.leaco.mybatis.generator.plugins.utils.PluginTools;
import pro.leaco.mybatis.generator.plugins.utils.XmlElementGeneratorTools;
import pro.leaco.mybatis.generator.plugins.utils.XmlElementTools;
import pro.leaco.mybatis.generator.plugins.utils.hook.ISelectOneByExamplePluginHook;
import pro.leaco.mybatis.generator.plugins.utils.hook.ISelectSelectivePluginHook;

public class SelectMapPlugin
extends BasePlugin
implements ISelectOneByExamplePluginHook {
    public static final String SELECT_BY_EXAMPLE_WHERE_CLAUSE = "Select_By_Example_Where_Clause";
    public static final String METHOD_SELECT_TO_MAP = "selectToMap";
    public static final String METHOD_SELECT_ONE_TO_MAP = "selectOneToMap";
    public static final String ID_FOR_PROPERTY_BASED_RESULT_MAP = "BasePropertyResultMap";
    private XmlElement select2MapEle;

    @Override
    public boolean validate(List<String> warnings) {
        if (!PluginTools.checkDependencyPlugin(this.getContext(), ModelColumnPlugin.class)) {
            warnings.add("itfsw:\u63d2\u4ef6" + this.getClass().getTypeName() + "\u63d2\u4ef6\u9700\u914d\u5408com.fuyo.mybatis.generator.plugins.ModelColumnPlugin\u63d2\u4ef6\u4f7f\u7528\uff01");
            return false;
        }
        return super.validate(warnings);
    }

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
        this.select2MapEle = null;
    }

    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        FormatTools.addMethodWithBestPosition(interfaze, this.addSelectToMapMethod(method, METHOD_SELECT_TO_MAP, "@Param(\"example\")", introspectedTable, false));
        return super.clientSelectByExampleWithBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (!introspectedTable.hasBLOBColumns()) {
            FormatTools.addMethodWithBestPosition(interfaze, this.addSelectToMapMethod(method, METHOD_SELECT_TO_MAP, "@Param(\"example\")", introspectedTable, false));
        }
        return super.clientSelectByExampleWithoutBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean sqlMapSelectByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.select2MapEle = this.generateSelectToMapXmlElement(METHOD_SELECT_TO_MAP, introspectedTable, false);
        return super.sqlMapSelectByExampleWithoutBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapSelectByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (!introspectedTable.hasBLOBColumns()) {
            this.select2MapEle = this.generateSelectToMapXmlElement(METHOD_SELECT_TO_MAP, introspectedTable, false);
        }
        return super.sqlMapSelectByExampleWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        if (introspectedTable.isConstructorBased()) {
            XmlElement resultMapEle = new XmlElement("resultMap");
            resultMapEle.addAttribute(new Attribute("id", ID_FOR_PROPERTY_BASED_RESULT_MAP));
            resultMapEle.addAttribute(new Attribute("type", introspectedTable.getRules().calculateAllFieldsClass().getFullyQualifiedName()));
            this.commentGenerator.addComment(resultMapEle);
            for (IntrospectedColumn introspectedColumn : introspectedTable.getPrimaryKeyColumns()) {
                resultMapEle.addElement((VisitableElement)XmlElementGeneratorTools.generateResultMapResultElement("id", introspectedColumn));
            }
            for (IntrospectedColumn introspectedColumn : introspectedTable.getNonPrimaryKeyColumns()) {
                resultMapEle.addElement((VisitableElement)XmlElementGeneratorTools.generateResultMapResultElement("result", introspectedColumn));
            }
            document.getRootElement().addElement(0, (VisitableElement)resultMapEle);
        }
        FormatTools.addElementWithBestPosition(document.getRootElement(), this.generateSelectByExampleWhereClauseElement(introspectedTable));
        if (this.select2MapEle != null) {
            FormatTools.addElementWithBestPosition(document.getRootElement(), this.select2MapEle);
            PluginTools.getHook(ISelectSelectivePluginHook.class).sqlMapSelectByExampleSelectiveElementGenerated(document, this.select2MapEle, introspectedTable);
        }
        return true;
    }

    @Override
    public boolean clientSelectOneByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        FormatTools.addMethodWithBestPosition(interfaze, this.addSelectToMapMethod(method, METHOD_SELECT_ONE_TO_MAP, "@Param(\"example\")", introspectedTable, true));
        return true;
    }

    @Override
    public boolean clientSelectOneByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (!introspectedTable.hasBLOBColumns()) {
            FormatTools.addMethodWithBestPosition(interfaze, this.addSelectToMapMethod(method, METHOD_SELECT_ONE_TO_MAP, "@Param(\"example\")", introspectedTable, true));
        }
        return true;
    }

    @Override
    public boolean sqlMapSelectOneByExampleWithoutBLOBsElementGenerated(Document document, XmlElement element, IntrospectedTable introspectedTable) {
        if (!introspectedTable.hasBLOBColumns()) {
            FormatTools.addElementWithBestPosition(document.getRootElement(), this.generateSelectOneByExampleSelectiveElement(introspectedTable));
        }
        return true;
    }

    @Override
    public boolean sqlMapSelectOneByExampleWithBLOBsElementGenerated(Document document, XmlElement element, IntrospectedTable introspectedTable) {
        FormatTools.addElementWithBestPosition(document.getRootElement(), this.generateSelectOneByExampleSelectiveElement(introspectedTable));
        return true;
    }

    private XmlElement generateSelectOneByExampleSelectiveElement(IntrospectedTable introspectedTable) {
        return this.generateSelectToMapXmlElement(METHOD_SELECT_ONE_TO_MAP, introspectedTable, true);
    }

    private XmlElement generateSelectByExampleWhereClauseElement(IntrospectedTable introspectedTable) {
        XmlElement element = new XmlElement("sql");
        this.commentGenerator.addComment(element);
        element.addAttribute(new Attribute("id", SELECT_BY_EXAMPLE_WHERE_CLAUSE));
        XmlElement where = new XmlElement("where");
        element.addElement((VisitableElement)where);
        XmlElement forEachEle = XmlElementTools.createElement("foreach", new Attribute("collection", "example.oredCriteria"), new Attribute("item", "criteria"), new Attribute("separator", "or"), () -> XmlElementTools.createElement("if", new Attribute("test", "criteria.valid"), () -> XmlElementTools.createElement("trim", new Attribute("prefix", "("), new Attribute("prefixOverrides", "and"), new Attribute("suffix", ")"), () -> XmlElementTools.createElement("foreach", new Attribute("collection", "criteria.criteria"), new Attribute("item", "criterion"), () -> XmlElementTools.createElement("choose", () -> XmlElementTools.createElement("when", new Attribute("test", "criterion.noValue"), () -> new TextElement("and ${criterion.condition}"), new Supplier[0]), () -> XmlElementTools.createElement("when", new Attribute("test", "criterion.singleValue"), () -> new TextElement("and ${criterion.condition} #{criterion.value}"), new Supplier[0]), () -> XmlElementTools.createElement("when", new Attribute("test", "criterion.betweenValue"), () -> new TextElement("and ${criterion.condition} #{criterion.value} and #{criterion.secondValue}"), new Supplier[0]), () -> XmlElementTools.createElement("when", new Attribute("test", "criterion.listValue"), () -> new TextElement("and ${criterion.condition}"), () -> XmlElementTools.createElement("foreach", new Attribute("close", ")"), new Attribute("collection", "criterion.value"), new Attribute("item", "listItem"), new Attribute("open", "("), new Attribute("separator", ","), () -> new TextElement("#{listItem}"), new Supplier[0]))), new Supplier[0]), new Supplier[0]), new Supplier[0]), new Supplier[0]);
        where.addElement((VisitableElement)forEachEle);
        XmlElement joinCriteriaEle = XmlElementTools.createElement("if", new Attribute("test", "example.joinCriteria!=null and example.joinCriteria.size()>0"), () -> XmlElementTools.createElement("foreach", new Attribute("collection", "example.joinCriteria"), new Attribute("item", "criteria"), () -> XmlElementTools.createElement("if", new Attribute("test", "criteria.valid"), () -> XmlElementTools.createElement("trim", new Attribute("prefix", "and ("), new Attribute("prefixOverrides", "and"), new Attribute("suffix", ")"), () -> XmlElementTools.createElement("foreach", new Attribute("collection", "criteria.criteria"), new Attribute("item", "criterion"), () -> XmlElementTools.createElement("choose", () -> XmlElementTools.createElement("when", new Attribute("test", "criterion.noValue"), () -> new TextElement("and ${criterion.condition}"), new Supplier[0]), () -> XmlElementTools.createElement("when", new Attribute("test", "criterion.singleValue"), () -> new TextElement("and ${criterion.condition} #{criterion.value}"), new Supplier[0]), () -> XmlElementTools.createElement("when", new Attribute("test", "criterion.betweenValue"), () -> new TextElement("and ${criterion.condition} #{criterion.value} and #{criterion.secondValue}"), new Supplier[0]), () -> XmlElementTools.createElement("when", new Attribute("test", "criterion.listValue"), () -> new TextElement("and ${criterion.condition}"), () -> XmlElementTools.createElement("foreach", new Attribute("close", ")"), new Attribute("collection", "criterion.value"), new Attribute("item", "listItem"), new Attribute("open", "("), new Attribute("separator", ","), () -> new TextElement("#{listItem}"), new Supplier[0]))), new Supplier[0]), new Supplier[0]), new Supplier[0]), new Supplier[0]), new Supplier[0]);
        where.addElement((VisitableElement)joinCriteriaEle);
        return element;
    }

    private XmlElement generateSelectToMapXmlElement(String id, IntrospectedTable introspectedTable, boolean selectOne) {
        XmlElement selectSelectiveEle = new XmlElement("select");
        this.commentGenerator.addComment(selectSelectiveEle);
        selectSelectiveEle.addAttribute(new Attribute("id", id));
        selectSelectiveEle.addAttribute(new Attribute("resultType", "java.util.Map"));
        selectSelectiveEle.addAttribute(new Attribute("parameterType", "map"));
        selectSelectiveEle.addElement((VisitableElement)new TextElement("select"));
        if (!selectOne) {
            XmlElement ifDistinctElement = new XmlElement("if");
            ifDistinctElement.addAttribute(new Attribute("test", "example != null and example.distinct"));
            ifDistinctElement.addElement((VisitableElement)new TextElement("distinct"));
            selectSelectiveEle.addElement((VisitableElement)ifDistinctElement);
        }
        if (StringUtility.stringHasValue((String)introspectedTable.getSelectByExampleQueryId())) {
            selectSelectiveEle.addElement((VisitableElement)new TextElement("'" + introspectedTable.getSelectByExampleQueryId() + "' as QUERYID,"));
        }
        selectSelectiveEle.addElement((VisitableElement)this.generateSelectiveElement(introspectedTable));
        selectSelectiveEle.addElement((VisitableElement)new TextElement("from " + introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime()));
        XmlElement ifJoinElement = new XmlElement("if");
        ifJoinElement.addAttribute(new Attribute("test", "example != null and example.joinClause != null"));
        ifJoinElement.addElement((VisitableElement)new TextElement("${example.joinClause}"));
        selectSelectiveEle.addElement((VisitableElement)ifJoinElement);
        XmlElement ifElement = new XmlElement("if");
        ifElement.addAttribute(new Attribute("test", "example != null"));
        XmlElement includeElement = new XmlElement("include");
        includeElement.addAttribute(new Attribute("refid", SELECT_BY_EXAMPLE_WHERE_CLAUSE));
        ifElement.addElement((VisitableElement)includeElement);
        selectSelectiveEle.addElement((VisitableElement)ifElement);
        XmlElement ifGroupByElement = new XmlElement("if");
        ifGroupByElement.addAttribute(new Attribute("test", "example != null and example.groupByClause != null"));
        ifGroupByElement.addElement((VisitableElement)new TextElement("group by ${example.groupByClause}"));
        selectSelectiveEle.addElement((VisitableElement)ifGroupByElement);
        XmlElement ifElement1 = new XmlElement("if");
        ifElement1.addAttribute(new Attribute("test", "example != null and example.orderByClause != null"));
        ifElement1.addElement((VisitableElement)new TextElement("order by ${example.orderByClause}"));
        selectSelectiveEle.addElement((VisitableElement)ifElement1);
        if (selectOne) {
            selectSelectiveEle.addElement((VisitableElement)new TextElement("limit 1"));
        }
        return selectSelectiveEle;
    }

    private XmlElement generateSelectiveElement(IntrospectedTable introspectedTable) {
        XmlElement chooseEle = new XmlElement("choose");
        XmlElement whenEle = new XmlElement("when");
        whenEle.addAttribute(new Attribute("test", "expressions != null and expressions.length > 0"));
        chooseEle.addElement((VisitableElement)whenEle);
        XmlElement keysEle = new XmlElement("foreach");
        whenEle.addElement((VisitableElement)keysEle);
        keysEle.addAttribute(new Attribute("collection", "expressions"));
        keysEle.addAttribute(new Attribute("item", "expression"));
        keysEle.addAttribute(new Attribute("separator", ","));
        keysEle.addElement((VisitableElement)new TextElement("${expression}"));
        return chooseEle;
    }

    private Method addSelectToMapMethod(Method method, String name, String firstAnnotation, IntrospectedTable introspectedTable, boolean selectOne) {
        Method method1 = JavaElementTools.clone(method);
        FormatTools.replaceGeneralMethodComment(this.commentGenerator, method1, introspectedTable);
        method1.setName(name);
        ((Parameter)method1.getParameters().get(0)).addAnnotation(firstAnnotation);
        method1.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "expressions", "@Param(\"expressions\")", true));
        if (selectOne) {
            method1.setReturnType(new FullyQualifiedJavaType("java.util.Map"));
        } else {
            method1.setReturnType(new FullyQualifiedJavaType("java.util.List<java.util.Map>"));
        }
        return method1;
    }

    private FullyQualifiedJavaType getModelColumnFullyQualifiedJavaType(IntrospectedTable introspectedTable) {
        return new FullyQualifiedJavaType(introspectedTable.getRules().calculateAllFieldsClass().getShortName() + "." + "Column");
    }
}

