/*
 * Decompiled with CFR 0.152.
 */
package pro.leaco.mybatis.generator.plugins;

import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.config.ColumnRenamingRule;
import org.mybatis.generator.config.DomainObjectRenamingRule;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;
import pro.leaco.mybatis.generator.plugins.utils.BasePlugin;
import pro.leaco.mybatis.generator.plugins.utils.BeanUtils;
import pro.leaco.mybatis.generator.plugins.utils.hook.ITableConfigurationHook;

public class TableRenameConfigurationPlugin
extends BasePlugin
implements ITableConfigurationHook {
    public static final String PRO_TABLE_SEARCH_STRING = "domainObjectRenamingRule.searchString";
    public static final String PRO_TABLE_REPLACE_STRING = "domainObjectRenamingRule.replaceString";
    public static final String PRO_TABLE_REPLACE_DISABLE = "domainObjectRenamingRule.disable";
    public static final String PRO_COLUMN_SEARCH_STRING = "columnRenamingRule.searchString";
    public static final String PRO_COLUMN_REPLACE_STRING = "columnRenamingRule.replaceString";
    public static final String PRO_COLUMN_REPLACE_DISABLE = "columnRenamingRule.disable";
    public static final String PRO_CLIENT_SUFFIX = "clientSuffix";
    public static final String PRO_EXAMPLE_SUFFIX = "exampleSuffix";
    public static final String PRO_MODEL_SUFFIX = "modelSuffix";
    private String tableSearchString;
    private String tableReplaceString;
    private boolean tableReplaceDisable;
    private String columnSearchString;
    private String columnReplaceString;
    private boolean columnReplaceDisable;
    private String clientSuffix;
    private String exampleSuffix;
    private String modelSuffix;

    @Override
    public boolean validate(List<String> warnings) {
        Properties properties = this.getProperties();
        this.tableSearchString = properties.getProperty(PRO_TABLE_SEARCH_STRING);
        this.tableReplaceString = properties.getProperty(PRO_TABLE_REPLACE_STRING);
        this.columnSearchString = properties.getProperty(PRO_COLUMN_SEARCH_STRING);
        this.columnReplaceString = properties.getProperty(PRO_COLUMN_REPLACE_STRING);
        this.exampleSuffix = properties.getProperty(PRO_EXAMPLE_SUFFIX);
        this.clientSuffix = properties.getProperty(PRO_CLIENT_SUFFIX);
        this.modelSuffix = properties.getProperty(PRO_MODEL_SUFFIX);
        return super.validate(warnings);
    }

    @Override
    public void tableConfiguration(IntrospectedTable introspectedTable) {
        try {
            StringBuilder sb;
            DomainObjectRenamingRule rule;
            TableConfiguration tableConfiguration = introspectedTable.getTableConfiguration();
            FullyQualifiedTable fullyQualifiedTable = introspectedTable.getFullyQualifiedTable();
            String tableReplaceDisable = tableConfiguration.getProperty(PRO_TABLE_REPLACE_DISABLE);
            this.tableReplaceDisable = tableReplaceDisable == null ? false : StringUtility.isTrue((String)tableReplaceDisable);
            String columnReplaceDisable = tableConfiguration.getProperty(PRO_COLUMN_REPLACE_DISABLE);
            this.columnReplaceDisable = columnReplaceDisable == null ? false : StringUtility.isTrue((String)columnReplaceDisable);
            String javaClientInterfacePackage = (String)BeanUtils.invoke(introspectedTable, IntrospectedTable.class, "calculateJavaClientInterfacePackage");
            String sqlMapPackage = (String)BeanUtils.invoke(introspectedTable, IntrospectedTable.class, "calculateSqlMapPackage");
            String javaModelPackage = (String)BeanUtils.invoke(introspectedTable, IntrospectedTable.class, "calculateJavaModelPackage");
            if (tableConfiguration.getDomainObjectRenamingRule() == null && this.tableSearchString != null && !this.tableReplaceDisable) {
                rule = new DomainObjectRenamingRule();
                rule.setSearchString(this.tableSearchString);
                rule.setReplaceString(this.tableReplaceString);
                tableConfiguration.setDomainObjectRenamingRule(rule);
                BeanUtils.setProperty(introspectedTable.getFullyQualifiedTable(), "domainObjectRenamingRule", rule);
                BeanUtils.invoke(introspectedTable, IntrospectedTable.class, "calculateJavaClientAttributes");
                BeanUtils.invoke(introspectedTable, IntrospectedTable.class, "calculateModelAttributes");
                BeanUtils.invoke(introspectedTable, IntrospectedTable.class, "calculateXmlAttributes");
            }
            if (tableConfiguration.getColumnRenamingRule() == null && this.columnSearchString != null && !this.columnReplaceDisable) {
                rule = new ColumnRenamingRule();
                rule.setSearchString(this.columnSearchString);
                rule.setReplaceString(this.columnReplaceString);
                tableConfiguration.setColumnRenamingRule((ColumnRenamingRule)rule);
                this.renameColumns(introspectedTable.getAllColumns(), (ColumnRenamingRule)rule, tableConfiguration);
            }
            if (this.clientSuffix != null) {
                sb = new StringBuilder();
                sb.append(javaClientInterfacePackage);
                sb.append('.');
                if (StringUtility.stringHasValue((String)tableConfiguration.getMapperName())) {
                    sb.append(tableConfiguration.getMapperName());
                } else {
                    if (StringUtility.stringHasValue((String)fullyQualifiedTable.getDomainObjectSubPackage())) {
                        sb.append(fullyQualifiedTable.getDomainObjectSubPackage());
                        sb.append('.');
                    }
                    sb.append(fullyQualifiedTable.getDomainObjectName());
                    sb.append(this.clientSuffix);
                }
                introspectedTable.setMyBatis3JavaMapperType(sb.toString());
                sb.setLength(0);
                sb.append(sqlMapPackage);
                sb.append('.');
                if (StringUtility.stringHasValue((String)tableConfiguration.getMapperName())) {
                    sb.append(tableConfiguration.getMapperName());
                } else {
                    sb.append(fullyQualifiedTable.getDomainObjectName());
                    sb.append(this.clientSuffix);
                }
                introspectedTable.setMyBatis3FallbackSqlMapNamespace(sb.toString());
                sb.setLength(0);
                sb.append(fullyQualifiedTable.getDomainObjectName());
                sb.append(this.clientSuffix);
                sb.append(".xml");
                introspectedTable.setMyBatis3XmlMapperFileName(sb.toString());
            }
            if (this.exampleSuffix != null) {
                sb = new StringBuilder();
                sb.append(javaModelPackage);
                sb.append('.');
                sb.append(fullyQualifiedTable.getDomainObjectName());
                sb.append(this.exampleSuffix);
                introspectedTable.setExampleType(sb.toString());
            }
            if (this.modelSuffix != null) {
                sb = new StringBuilder();
                sb.append(javaModelPackage);
                sb.append('.');
                sb.append(fullyQualifiedTable.getDomainObjectName());
                sb.append("Key");
                sb.append(this.modelSuffix);
                introspectedTable.setPrimaryKeyType(sb.toString());
                sb.setLength(0);
                sb.append(javaModelPackage);
                sb.append('.');
                sb.append(fullyQualifiedTable.getDomainObjectName());
                sb.append(this.modelSuffix);
                introspectedTable.setBaseRecordType(sb.toString());
                sb.setLength(0);
                sb.append(javaModelPackage);
                sb.append('.');
                sb.append(fullyQualifiedTable.getDomainObjectName());
                sb.append("WithBLOBs");
                sb.append(this.modelSuffix);
                introspectedTable.setRecordWithBLOBsType(sb.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renameColumns(List<IntrospectedColumn> columns, ColumnRenamingRule rule, TableConfiguration tc) {
        Pattern pattern = Pattern.compile(rule.getSearchString());
        String replaceString = rule.getReplaceString();
        replaceString = replaceString == null ? "" : replaceString;
        for (IntrospectedColumn introspectedColumn : columns) {
            String calculatedColumnName;
            if (pattern == null) {
                calculatedColumnName = introspectedColumn.getActualColumnName();
            } else {
                Matcher matcher = pattern.matcher(introspectedColumn.getActualColumnName());
                calculatedColumnName = matcher.replaceAll(replaceString);
            }
            if (StringUtility.isTrue((String)tc.getProperty("useActualColumnNames"))) {
                introspectedColumn.setJavaProperty(JavaBeansUtil.getValidPropertyName((String)calculatedColumnName));
                continue;
            }
            if (StringUtility.isTrue((String)tc.getProperty("useCompoundPropertyNames"))) {
                StringBuilder sb = new StringBuilder();
                sb.append(calculatedColumnName);
                sb.append('_');
                sb.append(JavaBeansUtil.getCamelCaseString((String)introspectedColumn.getRemarks(), (boolean)true));
                introspectedColumn.setJavaProperty(JavaBeansUtil.getValidPropertyName((String)sb.toString()));
                continue;
            }
            introspectedColumn.setJavaProperty(JavaBeansUtil.getCamelCaseString((String)calculatedColumnName, (boolean)false));
        }
    }
}

