/*
 * Decompiled with CFR 0.152.
 */
package pro.leaco.mybatis.generator.plugins.utils;

import java.util.List;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.internal.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.leaco.mybatis.generator.plugins.CommentPlugin;
import pro.leaco.mybatis.generator.plugins.utils.BeanUtils;
import pro.leaco.mybatis.generator.plugins.utils.PluginTools;
import pro.leaco.mybatis.generator.plugins.utils.enhanced.TemplateCommentGenerator;
import pro.leaco.mybatis.generator.plugins.utils.hook.HookAggregator;
import pro.leaco.mybatis.generator.plugins.utils.hook.ITableConfigurationHook;

public class BasePlugin
extends PluginAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(BasePlugin.class);
    protected CommentGenerator commentGenerator;
    protected List<String> warnings;
    public static final String PRO_MYBATIS_VERSION = "mybatisVersion";
    protected String mybatisVersion = "3.5.0";

    public void setContext(Context context) {
        super.setContext(context);
        HookAggregator.getInstance().setContext(context);
        PluginConfiguration cfg = PluginTools.getPluginConfiguration(context, CommentPlugin.class);
        if (cfg == null || cfg.getProperty("template") == null) {
            this.commentGenerator = context.getCommentGenerator();
        } else {
            TemplateCommentGenerator templateCommentGenerator = new TemplateCommentGenerator(context, cfg.getProperty("template"));
            this.commentGenerator = templateCommentGenerator;
            try {
                context.getCommentGenerator();
                BeanUtils.setProperty(context, "commentGenerator", templateCommentGenerator);
            }
            catch (Exception e) {
                logger.error("\u53cd\u5c04\u5f02\u5e38", (Throwable)e);
            }
        }
        if (StringUtility.stringHasValue((String)context.getProperty(PRO_MYBATIS_VERSION))) {
            this.mybatisVersion = context.getProperty(PRO_MYBATIS_VERSION);
        }
    }

    public boolean validate(List<String> warnings) {
        this.warnings = warnings;
        if (StringUtility.stringHasValue((String)this.getContext().getTargetRuntime()) && !"MyBatis3".equalsIgnoreCase(this.getContext().getTargetRuntime())) {
            warnings.add("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u8981\u6c42\u8fd0\u884ctargetRuntime\u5fc5\u987b\u4e3aMyBatis3\uff01");
            return false;
        }
        return true;
    }

    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
        if (StringUtility.stringHasValue((String)introspectedTable.getTableConfiguration().getAlias())) {
            this.warnings.add("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u8bf7\u4e0d\u8981\u914d\u7f6ealias\u5c5e\u6027\uff0c\u8fd9\u4e2a\u5c5e\u6027\u5b98\u65b9\u652f\u6301\u4e5f\u5f88\u6df7\u4e71\uff0c\u5bfc\u81f4\u63d2\u4ef6\u652f\u6301\u4f1a\u5b58\u5728\u95ee\u9898\uff01");
        }
        PluginTools.getHook(ITableConfigurationHook.class).tableConfiguration(introspectedTable);
        if (StringUtility.stringHasValue((String)this.getProperties().getProperty(PRO_MYBATIS_VERSION))) {
            this.mybatisVersion = this.getProperties().getProperty(PRO_MYBATIS_VERSION);
        }
    }
}

