/*
 * Decompiled with CFR 0.152.
 */
package pro.lukasgorny.services;

import com.google.common.base.Optional;
import com.google.gson.Gson;
import java.util.ArrayList;
import pro.lukasgorny.dto.FilterCriteria;
import pro.lukasgorny.dto.Match;
import pro.lukasgorny.dto.Player;
import pro.lukasgorny.services.DataAppendService;
import pro.lukasgorny.services.PlayerValidationService;

public class PlayerDataFilterService {
    private PlayerValidationService playerValidationService = new PlayerValidationService();
    private DataAppendService dataAppendService = new DataAppendService();

    public Player getPlayerByCriteria(String data, FilterCriteria criteria) {
        Player player = this.jsonToObject(data);
        Optional criteriaOptional = Optional.fromNullable((Object)criteria);
        if (criteriaOptional.isPresent()) {
            Optional modeOptional = Optional.fromNullable((Object)((Object)((FilterCriteria)criteriaOptional.get()).getMode()));
            Optional regionOptional = Optional.fromNullable((Object)((Object)((FilterCriteria)criteriaOptional.get()).getRegion()));
            Optional seasonOptional = Optional.fromNullable((Object)((Object)((FilterCriteria)criteriaOptional.get()).getSeason()));
            if (modeOptional.isPresent() && !regionOptional.isPresent() && !seasonOptional.isPresent()) {
                this.filterByMode(player, criteria);
            } else if (!modeOptional.isPresent() && regionOptional.isPresent() && !seasonOptional.isPresent()) {
                this.filterByRegion(player, criteria);
            } else if (!modeOptional.isPresent() && !regionOptional.isPresent() && seasonOptional.isPresent()) {
                this.filterBySeason(player, criteria);
            } else if (modeOptional.isPresent() && regionOptional.isPresent() && !seasonOptional.isPresent()) {
                this.filterByModeAndRegion(player, criteria);
            } else if (modeOptional.isPresent() && !regionOptional.isPresent() && seasonOptional.isPresent()) {
                this.filterByModeAndSeason(player, criteria);
            } else if (!modeOptional.isPresent() && regionOptional.isPresent() && seasonOptional.isPresent()) {
                this.filterByRegionAndSeason(player, criteria);
            } else if (modeOptional.isPresent() && regionOptional.isPresent() && seasonOptional.isPresent()) {
                this.filterByRegionAndModeAndSeason(player, criteria);
            }
        }
        return player;
    }

    private Player filterByMode(Player player, FilterCriteria criteria) {
        ArrayList<Match> results = new ArrayList<Match>();
        for (Match match : player.getMatches()) {
            if (!match.getMatchType().equals((Object)criteria.getMode())) continue;
            results.add(match);
        }
        player.setMatches(results);
        return player;
    }

    private Player filterByRegion(Player player, FilterCriteria criteria) {
        ArrayList<Match> results = new ArrayList<Match>();
        for (Match match : player.getMatches()) {
            if (!match.getRegion().equals((Object)criteria.getRegion())) continue;
            results.add(match);
        }
        player.setMatches(results);
        return player;
    }

    private Player filterBySeason(Player player, FilterCriteria criteria) {
        ArrayList<Match> results = new ArrayList<Match>();
        for (Match match : player.getMatches()) {
            if (!match.getSeason().equals(criteria.getSeason().getSeasonName())) continue;
            results.add(match);
        }
        player.setMatches(results);
        return player;
    }

    private Player filterByModeAndRegion(Player player, FilterCriteria criteria) {
        ArrayList<Match> results = new ArrayList<Match>();
        for (Match match : player.getMatches()) {
            if (!match.getMatchType().equals((Object)criteria.getMode()) || !match.getRegion().equals((Object)criteria.getRegion())) continue;
            results.add(match);
        }
        player.setMatches(results);
        return player;
    }

    private Player filterByModeAndSeason(Player player, FilterCriteria criteria) {
        ArrayList<Match> results = new ArrayList<Match>();
        for (Match match : player.getMatches()) {
            if (!match.getMatchType().equals((Object)criteria.getMode()) || !match.getSeason().equals(criteria.getSeason().getSeasonName())) continue;
            results.add(match);
        }
        player.setMatches(results);
        return player;
    }

    private Player filterByRegionAndSeason(Player player, FilterCriteria criteria) {
        ArrayList<Match> results = new ArrayList<Match>();
        for (Match match : player.getMatches()) {
            if (!match.getRegion().equals((Object)criteria.getRegion()) || !match.getSeason().equals(criteria.getSeason().getSeasonName())) continue;
            results.add(match);
        }
        player.setMatches(results);
        return player;
    }

    private Player filterByRegionAndModeAndSeason(Player player, FilterCriteria criteria) {
        ArrayList<Match> results = new ArrayList<Match>();
        for (Match match : player.getMatches()) {
            if (!match.getRegion().equals((Object)criteria.getRegion()) || !match.getMatchType().equals((Object)criteria.getMode()) || !match.getSeason().equals(criteria.getSeason().getSeasonName())) continue;
            results.add(match);
        }
        player.setMatches(results);
        return player;
    }

    private Player jsonToObject(String data) {
        Gson gson = new Gson();
        Player player = (Player)gson.fromJson(data, Player.class);
        this.playerValidationService.validate(player);
        this.dataAppendService.appendSeasonToStats(player);
        return player;
    }
}

