/*
 * Decompiled with CFR 0.152.
 */
package pro.lukasgorny.factory;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import pro.lukasgorny.core.JPubg;
import pro.lukasgorny.core.JPubgImpl;

public final class JPubgFactory {
    public static JPubg getWrapper(@Nonnull String apiKey) {
        JPubgFactory.validateApiKey(apiKey);
        return new JPubgImpl(apiKey);
    }

    public static JPubg getWrapper(@Nonnull String apiKey, int connectionTimeout) {
        JPubgFactory.validateApiKey(apiKey);
        return new JPubgImpl(apiKey, connectionTimeout);
    }

    private static void validateApiKey(String apiKey) {
        Preconditions.checkArgument((apiKey != null || !apiKey.trim().isEmpty() ? 1 : 0) != 0, (Object)"Specified API Key is null or empty. Cannot proceed.");
    }
}

