/*
 * Decompiled with CFR 0.152.
 */
package pro.lukasgorny.services;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import pro.lukasgorny.dto.Match;

public class MatchValidationService {
    public void validate(List<Match> matches) {
        Optional optionalMatches = Optional.fromNullable(matches);
        Preconditions.checkArgument((boolean)optionalMatches.isPresent(), (Object)"Cannot get match from season, because list of matches is null.");
        Preconditions.checkArgument((!((List)optionalMatches.get()).isEmpty() ? 1 : 0) != 0, (Object)"Cannot get match from season, because list of matches is empty.");
    }

    public void validateWithSizeValidation(List<Match> matches) {
        this.validate(matches);
        Preconditions.checkArgument((matches.size() == 1 ? 1 : 0) != 0, (Object)"Cannot get match from season, because specified match list has more than one season data.");
    }

    public void validateSingleMatch(Match match) {
        Optional matchOptional = Optional.fromNullable((Object)match);
        Preconditions.checkState((boolean)matchOptional.isPresent(), (Object)"Cannot get match from season, because returned match object is null.");
    }
}

