/*
 * Decompiled with CFR 0.152.
 */
package pro.lukasgorny.core;

import pro.lukasgorny.core.JPubg;
import pro.lukasgorny.dto.Player;
import pro.lukasgorny.enums.PUBGMode;
import pro.lukasgorny.enums.PUBGRegion;
import pro.lukasgorny.exceptions.ApiException;
import pro.lukasgorny.services.DataFilterService;
import pro.lukasgorny.services.HttpService;

public class JPubgImpl
implements JPubg {
    private HttpService httpService;
    private DataFilterService dataFilterService;

    public JPubgImpl(String apiKey) {
        this.httpService = new HttpService(apiKey);
        this.dataFilterService = new DataFilterService();
    }

    @Override
    public String getByNickname(String nickname) throws ApiException {
        return this.httpService.executeGetByNicknameAction(nickname);
    }

    @Override
    public Player getByNickname(String nickname, PUBGMode mode) throws ApiException {
        String data = this.httpService.executeGetByNicknameAction(nickname);
        return this.dataFilterService.filterByMode(data, mode);
    }

    @Override
    public Player getByNickname(String nickname, PUBGRegion region) throws ApiException {
        String data = this.httpService.executeGetByNicknameAction(nickname);
        return this.dataFilterService.filterByRegion(data, region);
    }

    @Override
    public Player getByNickname(String nickname, PUBGMode mode, PUBGRegion region) throws ApiException {
        String data = this.httpService.executeGetByNicknameAction(nickname);
        return this.dataFilterService.filterByModeAndRegion(data, mode, region);
    }

    @Override
    public String getBySteamID(String steamID) throws ApiException {
        return this.httpService.executeGetBySteamIDAction(steamID);
    }

    @Override
    public Player getBySteamID(String steamID, PUBGMode mode) throws ApiException {
        String data = this.httpService.executeGetBySteamIDAction(steamID);
        return this.dataFilterService.filterByMode(data, mode);
    }

    @Override
    public Player getBySteamID(String steamID, PUBGRegion region) throws ApiException {
        String data = this.httpService.executeGetBySteamIDAction(steamID);
        return this.dataFilterService.filterByRegion(data, region);
    }

    @Override
    public Player getBySteamID(String steamID, PUBGMode mode, PUBGRegion region) throws ApiException {
        String data = this.httpService.executeGetBySteamIDAction(steamID);
        return this.dataFilterService.filterByModeAndRegion(data, mode, region);
    }
}

