/*
 * Decompiled with CFR 0.152.
 */
package pro.lukasgorny.core;

import pro.lukasgorny.core.JPubg;
import pro.lukasgorny.dto.Player;
import pro.lukasgorny.dto.Stat;
import pro.lukasgorny.enums.PUBGMode;
import pro.lukasgorny.enums.PUBGRegion;
import pro.lukasgorny.enums.PUBGStat;
import pro.lukasgorny.exceptions.ApiException;
import pro.lukasgorny.services.HttpService;
import pro.lukasgorny.services.MatchStatFilterService;
import pro.lukasgorny.services.PlayerDataFilterService;

public class JPubgImpl
implements JPubg {
    private HttpService httpService;
    private PlayerDataFilterService playerDataFilterService;
    private MatchStatFilterService matchStatFilterService;

    public JPubgImpl(String apiKey) {
        this.httpService = new HttpService(apiKey);
        this.playerDataFilterService = new PlayerDataFilterService();
        this.matchStatFilterService = new MatchStatFilterService();
    }

    public JPubgImpl(String apiKey, int connectionTimeout) {
        this.httpService = new HttpService(apiKey, connectionTimeout);
        this.playerDataFilterService = new PlayerDataFilterService();
        this.matchStatFilterService = new MatchStatFilterService();
    }

    @Override
    public String getByNickname(String nickname) throws ApiException {
        return this.httpService.executeGetByNicknameAction(nickname);
    }

    @Override
    public Player getByNickname(String nickname, PUBGMode mode) throws ApiException {
        String data = this.httpService.executeGetByNicknameAction(nickname);
        return this.playerDataFilterService.filterByMode(data, mode);
    }

    @Override
    public Player getByNickname(String nickname, PUBGRegion region) throws ApiException {
        String data = this.httpService.executeGetByNicknameAction(nickname);
        return this.playerDataFilterService.filterByRegion(data, region);
    }

    @Override
    public Player getByNickname(String nickname, PUBGMode mode, PUBGRegion region) throws ApiException {
        String data = this.httpService.executeGetByNicknameAction(nickname);
        return this.playerDataFilterService.filterByModeAndRegion(data, mode, region);
    }

    @Override
    public String getBySteamID(String steamID) throws ApiException {
        return this.httpService.executeGetBySteamIDAction(steamID);
    }

    @Override
    public Player getBySteamID(String steamID, PUBGMode mode) throws ApiException {
        String data = this.httpService.executeGetBySteamIDAction(steamID);
        return this.playerDataFilterService.filterByMode(data, mode);
    }

    @Override
    public Player getBySteamID(String steamID, PUBGRegion region) throws ApiException {
        String data = this.httpService.executeGetBySteamIDAction(steamID);
        return this.playerDataFilterService.filterByRegion(data, region);
    }

    @Override
    public Player getBySteamID(String steamID, PUBGMode mode, PUBGRegion region) throws ApiException {
        String data = this.httpService.executeGetBySteamIDAction(steamID);
        return this.playerDataFilterService.filterByModeAndRegion(data, mode, region);
    }

    @Override
    public Stat getPlayerMatchStatByStatName(Player player, PUBGStat stat) throws ApiException {
        return this.matchStatFilterService.filterPlayerMatchStatByStatName(player, stat);
    }
}

