/*
 * Decompiled with CFR 0.152.
 */
package pro.lukasgorny.services;

import java.util.List;
import java.util.stream.Collectors;
import pro.lukasgorny.dto.Player;
import pro.lukasgorny.dto.Stat;
import pro.lukasgorny.enums.PUBGStat;
import pro.lukasgorny.exceptions.ApiException;

public class MatchStatFilterService {
    public Stat filterPlayerMatchStatByStatName(Player player, PUBGStat statName) throws ApiException {
        if (player == null) {
            throw new ApiException("Cannot get player match stat, because player object returned is null!");
        }
        if (player.getMatches() == null || player.getMatches().isEmpty()) {
            throw new ApiException("Specified player has no matches played, no stats can be filtered.");
        }
        List results = player.getMatches().get(player.getMatches().size() - 1).getStats().stream().filter(stat -> statName.getLabelName().equals(stat.getField())).collect(Collectors.toList());
        if (results.size() != 1) {
            throw new ApiException("More than one stat or no stats with given name was returned while filtering matches. This is an error.");
        }
        return (Stat)results.get(0);
    }
}

