/*
 * Decompiled with CFR 0.152.
 */
package pro.lukasgorny.services;

import com.google.gson.Gson;
import java.util.stream.Collectors;
import pro.lukasgorny.dto.Player;
import pro.lukasgorny.enums.PUBGMode;
import pro.lukasgorny.enums.PUBGRegion;
import pro.lukasgorny.exceptions.ApiException;

public class PlayerDataFilterService {
    public Player filterByMode(String data, PUBGMode mode) throws ApiException {
        Player player = this.jsonToObject(data);
        if (player == null) {
            throw new ApiException("Cannot filter player data, because player object returned is null!");
        }
        if (player.getMatches() == null || player.getMatches().isEmpty()) {
            throw new ApiException("Specified player has no matches played, no stats can be filtered.");
        }
        player.setMatches(player.getMatches().stream().filter(stat -> mode.equals((Object)stat.getMatchType())).collect(Collectors.toList()));
        return player;
    }

    public Player filterByRegion(String data, PUBGRegion region) throws ApiException {
        Player player = this.jsonToObject(data);
        if (player == null) {
            throw new ApiException("Cannot filter player data, because player object returned is null!");
        }
        if (player.getMatches() == null || player.getMatches().isEmpty()) {
            throw new ApiException("Specified player has no matches played, no stats can be filtered.");
        }
        player.setMatches(player.getMatches().stream().filter(stat -> region.equals((Object)stat.getRegion())).collect(Collectors.toList()));
        return player;
    }

    public Player filterByModeAndRegion(String data, PUBGMode mode, PUBGRegion region) throws ApiException {
        Player player = this.jsonToObject(data);
        if (player == null) {
            throw new ApiException("Cannot filter player data, because player object returned is null!");
        }
        if (player.getMatches() == null || player.getMatches().isEmpty()) {
            throw new ApiException("Specified player has no matches played, no stats can be filtered.");
        }
        player.setMatches(player.getMatches().stream().filter(stat -> region.equals((Object)stat.getRegion()) && mode.equals((Object)stat.getMatchType())).collect(Collectors.toList()));
        return player;
    }

    private Player jsonToObject(String data) {
        Gson gson = new Gson();
        return gson.fromJson(data, Player.class);
    }
}

