/*
 * Decompiled with CFR 0.152.
 */
package pro.lukasgorny.core;

import java.io.IOException;
import javax.annotation.Nonnull;
import pro.lukasgorny.core.JPubg;
import pro.lukasgorny.dto.FilterCriteria;
import pro.lukasgorny.dto.Player;
import pro.lukasgorny.dto.Stat;
import pro.lukasgorny.enums.PUBGStat;
import pro.lukasgorny.exceptions.BadResponseCodeException;
import pro.lukasgorny.services.HttpService;
import pro.lukasgorny.services.MatchStatFilterService;
import pro.lukasgorny.services.PlayerDataFilterService;

public class JPubgImpl
implements JPubg {
    private HttpService httpService;
    private PlayerDataFilterService playerDataFilterService;
    private MatchStatFilterService matchStatFilterService;

    public JPubgImpl(String apiKey) {
        this.httpService = new HttpService(apiKey);
        this.playerDataFilterService = new PlayerDataFilterService();
        this.matchStatFilterService = new MatchStatFilterService();
    }

    public JPubgImpl(String apiKey, int connectionTimeout) {
        this.httpService = new HttpService(apiKey, connectionTimeout);
        this.playerDataFilterService = new PlayerDataFilterService();
        this.matchStatFilterService = new MatchStatFilterService();
    }

    @Override
    public String getByNickname(@Nonnull String nickname) throws IOException, BadResponseCodeException {
        return this.httpService.executeGetByNicknameAction(nickname);
    }

    @Override
    public Player getByNickname(@Nonnull String nickname, FilterCriteria criteria) throws IOException, BadResponseCodeException {
        String data = this.httpService.executeGetByNicknameAction(nickname);
        return this.playerDataFilterService.getPlayerByCriteria(data, criteria);
    }

    @Override
    public String getBySteamID(@Nonnull String steamID) throws IOException, BadResponseCodeException {
        return this.httpService.executeGetBySteamIDAction(steamID);
    }

    @Override
    public Player getBySteamID(@Nonnull String steamID, FilterCriteria criteria) throws IOException, BadResponseCodeException {
        String data = this.httpService.executeGetBySteamIDAction(steamID);
        return this.playerDataFilterService.getPlayerByCriteria(data, criteria);
    }

    @Override
    public Stat getPlayerMatchStatByStatName(@Nonnull Player player, @Nonnull PUBGStat stat) {
        return this.matchStatFilterService.getStatFromSeasonMatches(player.getMatches(), stat);
    }
}

