/*
 * Decompiled with CFR 0.152.
 */
package pro.lukasgorny.services;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import pro.lukasgorny.exceptions.BadResponseCodeException;
import pro.lukasgorny.utils.MessageUtils;
import pro.lukasgorny.utils.UrlUtils;

public class HttpService {
    private URL url;
    private String apiKey;
    private HttpURLConnection connection;
    private int connectionTimeout = 5000;

    public HttpService(String apiKey) {
        this.apiKey = apiKey;
    }

    public HttpService(String apiKey, int connectionTimeout) {
        this.apiKey = apiKey;
        this.connectionTimeout = connectionTimeout;
    }

    public String executeGetByNicknameAction(String nickname) throws IOException, BadResponseCodeException {
        Preconditions.checkArgument((nickname != null || !nickname.isEmpty() ? 1 : 0) != 0, (Object)"Nickname argument must not be null or empty!");
        String response = this.sendGetByNicknameRequest(nickname);
        Preconditions.checkState((!response.isEmpty() ? 1 : 0) != 0, (Object)"FATAL ERROR! Empty response returned!");
        return response;
    }

    public String executeGetBySteamIDAction(String steamID) throws IOException, BadResponseCodeException {
        Preconditions.checkArgument((steamID != null || !steamID.isEmpty() ? 1 : 0) != 0, (Object)"SteamID argument must not be null or empty!");
        String response = this.sendGetBySteamIDRequest(steamID);
        Preconditions.checkState((!response.isEmpty() ? 1 : 0) != 0, (Object)"FATAL ERROR! Empty response returned!");
        return response;
    }

    private String sendGetByNicknameRequest(String nickname) throws IOException, BadResponseCodeException {
        return this.sendGetRequest(UrlUtils.prepareNicknameRequestURL(nickname));
    }

    private String sendGetBySteamIDRequest(String steamID) throws IOException, BadResponseCodeException {
        return this.sendGetRequest(UrlUtils.prepareSteamIDRequestURL(steamID));
    }

    private String sendGetRequest(String urlString) throws IOException, BadResponseCodeException {
        this.prepareURL(urlString);
        this.prepareAndOpenConnection();
        this.setRequestProperties();
        return this.processResponse();
    }

    private void prepareURL(String urlString) throws MalformedURLException {
        this.url = new URL(urlString);
    }

    private void prepareAndOpenConnection() throws IOException {
        this.connection = (HttpURLConnection)this.url.openConnection();
    }

    private void setRequestProperties() throws ProtocolException {
        this.connection.setConnectTimeout(this.connectionTimeout);
        this.connection.setRequestMethod("GET");
        this.connection.setRequestProperty("User-Agent", "Mozilla/5.0");
        this.connection.setRequestProperty("TRN-Api-Key", this.apiKey);
    }

    private String processResponse() throws IOException, BadResponseCodeException {
        String output;
        int responseCode = this.connection.getResponseCode();
        if (responseCode != 200) {
            throw new BadResponseCodeException(MessageUtils.prepareBadCodeErrorMessage(responseCode));
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((output = bufferedReader.readLine()) != null) {
            response.append(output);
        }
        bufferedReader.close();
        return response.toString();
    }
}

