/*
 * Decompiled with CFR 0.152.
 */
package pro.lukasgorny.services;

import com.google.common.base.Optional;
import com.google.gson.Gson;
import java.util.stream.Collectors;
import pro.lukasgorny.dto.FilterCriteria;
import pro.lukasgorny.dto.Player;
import pro.lukasgorny.services.DataAppendService;
import pro.lukasgorny.services.PlayerValidationService;

public class PlayerDataFilterService {
    private PlayerValidationService playerValidationService = new PlayerValidationService();
    private DataAppendService dataAppendService = new DataAppendService();

    public Player getPlayerByCriteria(String data, FilterCriteria criteria) {
        Player player = this.jsonToObject(data);
        Optional criteriaOptional = Optional.fromNullable((Object)criteria);
        Optional modeOptional = Optional.fromNullable((Object)((Object)((FilterCriteria)criteriaOptional.get()).getMode()));
        Optional regionOptional = Optional.fromNullable((Object)((Object)((FilterCriteria)criteriaOptional.get()).getRegion()));
        Optional seasonOptional = Optional.fromNullable((Object)((Object)((FilterCriteria)criteriaOptional.get()).getSeason()));
        this.playerValidationService.validate(player);
        if (modeOptional.isPresent() && !regionOptional.isPresent() && !seasonOptional.isPresent()) {
            this.filterByMode(player, criteria);
        } else if (!modeOptional.isPresent() && regionOptional.isPresent() && !seasonOptional.isPresent()) {
            this.filterByRegion(player, criteria);
        } else if (!modeOptional.isPresent() && !regionOptional.isPresent() && seasonOptional.isPresent()) {
            this.filterBySeason(player, criteria);
        } else if (modeOptional.isPresent() && regionOptional.isPresent() && !seasonOptional.isPresent()) {
            this.filterByModeAndRegion(player, criteria);
        } else if (modeOptional.isPresent() && !regionOptional.isPresent() && seasonOptional.isPresent()) {
            this.filterByModeAndSeason(player, criteria);
        } else if (!modeOptional.isPresent() && regionOptional.isPresent() && seasonOptional.isPresent()) {
            this.filterByRegionAndSeason(player, criteria);
        } else if (modeOptional.isPresent() && regionOptional.isPresent() && seasonOptional.isPresent()) {
            this.filterByRegionAndModeAndSeason(player, criteria);
        } else {
            return player;
        }
        return player;
    }

    private Player filterByMode(Player player, FilterCriteria criteria) {
        player.setMatches(player.getMatches().stream().filter(match -> criteria.getMode().equals((Object)match.getMatchType())).collect(Collectors.toList()));
        return player;
    }

    private Player filterByRegion(Player player, FilterCriteria criteria) {
        player.setMatches(player.getMatches().stream().filter(match -> criteria.getRegion().equals((Object)match.getRegion())).collect(Collectors.toList()));
        return player;
    }

    private Player filterByModeAndRegion(Player player, FilterCriteria criteria) {
        player.setMatches(player.getMatches().stream().filter(match -> criteria.getRegion().equals((Object)match.getRegion()) && criteria.getMode().equals((Object)match.getMatchType())).collect(Collectors.toList()));
        return player;
    }

    private Player filterBySeason(Player player, FilterCriteria criteria) {
        player.setMatches(player.getMatches().stream().filter(match -> criteria.getSeason().getSeasonName().equals(match.getSeason())).collect(Collectors.toList()));
        return player;
    }

    private Player filterByModeAndSeason(Player player, FilterCriteria criteria) {
        player.setMatches(player.getMatches().stream().filter(match -> criteria.getSeason().getSeasonName().equals(match.getSeason()) && criteria.getMode().equals((Object)match.getMatchType())).collect(Collectors.toList()));
        return player;
    }

    private Player filterByRegionAndSeason(Player player, FilterCriteria criteria) {
        player.setMatches(player.getMatches().stream().filter(match -> criteria.getSeason().getSeasonName().equals(match.getSeason()) && criteria.getRegion().equals((Object)match.getRegion())).collect(Collectors.toList()));
        return player;
    }

    private Player filterByRegionAndModeAndSeason(Player player, FilterCriteria criteria) {
        player.setMatches(player.getMatches().stream().filter(match -> criteria.getSeason().getSeasonName().equals(match.getSeason()) && criteria.getRegion().equals((Object)match.getRegion()) && criteria.getMode().equals((Object)match.getMatchType())).collect(Collectors.toList()));
        return player;
    }

    private Player jsonToObject(String data) {
        Gson gson = new Gson();
        Player player = (Player)gson.fromJson(data, Player.class);
        this.dataAppendService.appendSeasonToStats(player);
        return player;
    }
}

