/*
 * Decompiled with CFR 0.152.
 */
package pro.lukasgorny.services;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import pro.lukasgorny.dto.Match;
import pro.lukasgorny.dto.Stat;
import pro.lukasgorny.enums.PUBGStat;
import pro.lukasgorny.services.MatchValidationService;

public class MatchStatFilterService {
    private MatchValidationService matchValidationService = new MatchValidationService();

    public Stat getStatFromSeasonMatches(List<Match> matches, PUBGStat statName) {
        Match match = this.getMatchFromSeason(matches);
        List results = match.getStats().stream().filter(stat -> statName.getLabelName().equals(stat.getField())).collect(Collectors.toList());
        Preconditions.checkState((results.size() == 1 ? 1 : 0) != 0, (Object)"More than one stat or no stats with given name was returned while filtering matches.");
        return (Stat)results.get(0);
    }

    private Match getMatchFromSeason(List<Match> matches) {
        this.matchValidationService.validateWithSizeValidation(matches);
        Optional optionalMatches = Optional.fromNullable(matches);
        Match match = (Match)((List)optionalMatches.get()).get(0);
        this.matchValidationService.validateSingleMatch(match);
        return match;
    }
}

