/*
 * Decompiled with CFR 0.152.
 */
package pro.mickey.logically.deleted;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SqlLogicallyDeleted {
    private String variable;
    private String variable_delete;
    private String variable_delete_not;
    private String sql_type;

    public SqlLogicallyDeleted(String variable, String variable_delete, String variable_delete_not, String sql_type) {
        this.variable = variable;
        this.variable_delete = variable_delete;
        this.variable_delete_not = variable_delete_not;
        this.sql_type = sql_type;
    }

    public String logicallyDeleted(String sql) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (String)this.sql_type);
        List stmtList = parser.parseStatementList();
        SQLStatement stmt = (SQLStatement)stmtList.get(0);
        if (stmt instanceof SQLDeleteStatement) {
            SQLDeleteStatement sstmt = (SQLDeleteStatement)stmt;
            return this.deleteToUpdate(sstmt);
        }
        if (stmt instanceof SQLSelectStatement) {
            SQLSelectStatement sstmt = (SQLSelectStatement)stmt;
            return this.selectAddWhere(sstmt);
        }
        return sql;
    }

    private String deleteToUpdate(SQLDeleteStatement deleteStatement) {
        StringBuffer buf = new StringBuffer();
        buf.append("UPDATE ");
        deleteStatement.getTableSource().output(buf);
        buf.append(" SET ");
        List<String> list = this.getFrom(deleteStatement.getTableSource());
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                String as = list.get(i);
                StringBuffer whereSql = new StringBuffer();
                if (as != null && as.length() > 0) {
                    whereSql.append(as);
                    whereSql.append(".");
                }
                whereSql.append(this.variable);
                whereSql.append(" = ");
                whereSql.append(this.variable_delete);
                buf.append(whereSql);
            }
        }
        if (deleteStatement.getWhere() != null) {
            buf.append(" WHERE ");
            SQLExpr opExpr = deleteStatement.getWhere();
            buf.append(SQLUtils.toSQLString((SQLObject)opExpr));
        }
        return buf.toString();
    }

    private String selectAddWhere(SQLSelectStatement sstmt) {
        List<String> list;
        SQLSelect sqlselect = sstmt.getSelect();
        SQLSelectQueryBlock query = (SQLSelectQueryBlock)sqlselect.getQuery();
        if (query != null && query.getFrom() != null && (list = this.getFrom(query.getFrom())) != null) {
            for (String as : list) {
                StringBuffer whereSql = new StringBuffer();
                if (as != null && as.length() > 0) {
                    whereSql.append(as);
                    whereSql.append(".");
                }
                whereSql.append(this.variable);
                whereSql.append(" = ");
                whereSql.append(this.variable_delete_not);
                SQLExpr expr = new SQLExprParser(whereSql.toString(), this.sql_type).expr();
                query.addWhere(expr);
            }
        }
        return sstmt.toString();
    }

    private List<String> getFrom(SQLTableSource tableFrom) {
        String[] tabs;
        StringBuffer buffer = new StringBuffer();
        tableFrom.accept((SQLASTVisitor)new SQLASTOutputVisitor((Appendable)buffer));
        String tables = buffer.toString();
        tables = tables.split("\n")[0];
        ArrayList<String> list = new ArrayList<String>();
        if (buffer == null || buffer.length() <= 0) {
            return null;
        }
        for (String tab : tabs = tables.split(", ")) {
            String[] names = tab.split(" ");
            if (names.length > 1) {
                list.add(names[1]);
                continue;
            }
            list.add(null);
        }
        return list;
    }
}

