/*
 * Decompiled with CFR 0.152.
 */
package pro.mickey.spring.rest.back.validation;

import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import pro.mickey.spring.rest.back.BackRest;
import pro.mickey.spring.rest.back.RestBack;
import pro.mickey.spring.rest.back.config.BackCodeConfig;

@RestControllerAdvice
public class ValidationBeanExceptionCapture {
    private Map<String, String> all = new HashMap<String, String>();

    public ValidationBeanExceptionCapture() {
        this.all.put("Null", "\u5fc5\u987b\u4e3aNULL");
        this.all.put("NotNull", "\u4e0d\u80fd\u4e3a\u7a7a");
        this.all.put("AssertTrue", "\u5fc5\u987b\u4e3atrue");
        this.all.put("AssertFalse", "\u5fc5\u987b\u4e3afalse");
        this.all.put("Min", "\u5fc5\u987b\u5927\u4e8exxxx");
        this.all.put("Max", "\u5fc5\u987b\u5c0f\u4e8exxxx");
        this.all.put("DecimalMin", "\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8exxxx");
        this.all.put("DecimalMax", "\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8exxxx");
        this.all.put("Size", "\u5fc5\u987b\u5728\u5236\u5b9a\u7684\u8303\u56f4\u5185");
        this.all.put("Digits", "\u5fc5\u987b\u662f\u6570\u5b57\uff0c\u5fc5\u987b\u5728\u53ef\u63a5\u53d7\u7684\u8303\u56f4\u5185");
        this.all.put("Past", "\u5fc5\u987b\u662f\u4e00\u4e2a\u8fc7\u53bb\u7684\u65e5\u671f");
        this.all.put("Future", "\u5fc5\u987b\u662f\u4e00\u4e2a\u5c06\u6765\u7684\u65e5\u671f");
        this.all.put("Email", "\u5fc5\u987b\u662f\u7535\u5b50\u90ae\u7bb1\u5730\u5740");
        this.all.put("Length", "\u5fc5\u987b\u5728\u6307\u5b9a\u7684\u8303\u56f4\u5185");
        this.all.put("NotEmpty", "\u5fc5\u987b\u975e\u7a7a");
        this.all.put("NotBlank", "\u5fc5\u987b\u975e\u7a7a");
        this.all.put("URL", "\u5fc5\u987b\u662f\u4e00\u4e2a\u6709\u6548\u7684url");
        this.all.put("CreditCardNumber", "\u94f6\u884c\u5361\uff0c\u4fe1\u7528\u5361\u7b49\u53f7\u7801\u4e00\u822c\u90fd\u7528Luhn\u8ba1\u7b97\u5408\u6cd5\u6027");
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.OK)
    private RestBack exception(MethodArgumentNotValidException ex) {
        BindingResult bindingResult = ex.getBindingResult();
        String errorMesssage = "\u53c2\u6570\u9519\u8bef:";
        for (FieldError fieldError : bindingResult.getFieldErrors()) {
            errorMesssage = errorMesssage + " AND " + fieldError.getField() + this.all.get(fieldError.getCode()) + "," + fieldError.getDefaultMessage() + "";
        }
        return BackRest.error(BackCodeConfig.backValidationError, errorMesssage);
    }
}

