/*
 * Decompiled with CFR 0.152.
 */
package pro.mickey;

import java.util.Calendar;

public class MickeySnowflake {
    private static final int WORKER_ID_BITS = 10;
    private static final int SEQUENCE_BITS = 12;
    private static final int WORKER_ID_SEQUENCE_BITS = 22;
    private static final int WORKER_ID_MAX_VALUE = 1024;
    private static final int SEQUENCE_MASK = 4095;
    private int workerId;
    private long sequence;
    private long lastTime;
    public static final long EPOCH;

    public MickeySnowflake(int workerId) {
        if ((long)workerId < 0L || workerId >= 1024) {
            new IllegalArgumentException("\u673a\u5668\u7801\u8d85\u51fa\u8303\u56f4");
        }
        this.workerId = workerId;
    }

    public synchronized long generateKey() {
        long currentMillis = System.currentTimeMillis();
        if (this.lastTime > currentMillis) {
            new IllegalArgumentException("\u65f6\u95f4\u9519\u8bef,\u65f6\u95f4\u4e0d\u4f1a\u5411\u540e\u79fb\u52a8");
        }
        if (this.lastTime == currentMillis) {
            if (0L == (++this.sequence & 0xFFFL)) {
                currentMillis = this.waitUntilNextTime(currentMillis);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTime = currentMillis;
        return currentMillis - EPOCH << 22 | (long)(this.workerId << 12) | this.sequence;
    }

    private long waitUntilNextTime(long lastTime) {
        long time = System.currentTimeMillis();
        while (time <= lastTime) {
            time = System.currentTimeMillis();
        }
        return time;
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2017, 8, 18);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        EPOCH = calendar.getTimeInMillis();
    }
}

