package pro.mypvit.requests;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.SuperBuilder;

/**
 * Represents a request for initiating a REST transaction in the MyPVit SDK.
 *
 * <p>This class extends {@link BaseTransactionRequest} to inherit all common transaction fields
 * required for REST transactions.</p>
 *
 * Key Features:
 * <ul>
 *     <li>Inherits all fields and functionalities of {@link BaseTransactionRequest}.</li>
 *     <li>Specifically designed for transactions sent to the REST API endpoint of MyPVit.</li>
 *     <li>Supports builder pattern for convenient object creation via {@link SuperBuilder}.</li>
 * </ul>
 *
 * Usage:
 * This class is used to build REST transaction requests for MyPVit. The JSON representation
 * of this class is automatically serialized using the `toJson()` method provided by {@link AbstractRequest}.
 *
 * Example:
 * <pre>
 * TransactionRestRequest request = TransactionRestRequest.builder()
 *     .agent("AGENT-1")
 *     .amount(150.0)
 *     .product("PRODUCT_NAME")
 *     .reference("REF123456")
 *     .customerAccountNumber("123456789")
 *     .service("RESTFUL")
 *     .callbackUrlCode("GIGMY")
 *     .merchantOperationAccountCode("ACC_6718284F467E6")
 *     .transactionType("PAYMENT")
 *     .ownerCharge("MERCHANT")
 *     .ownerChargeOperator("CUSTOMER")
 *     .freeInfo("Some additional information")
 *     .build();
 *
 * String json = request.toJson();
 * System.out.println(json);
 * </pre>
 */
@Data
@SuperBuilder
@EqualsAndHashCode(callSuper = true)
public class TransactionRestRequest extends BaseTransactionRequest{
    /**
     * Default constructor
     */
    public TransactionRestRequest() {}
}