package pro.mypvit.responses;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * Represents the response for a balance inquiry in the MyPVit SDK.
 *
 * <p>This class extends {@link AbstractResponse} to inherit functionality for JSON deserialization
 * and provides specific fields for balance-related information.</p>
 *
 * Key Features:
 * <ul>
 *     <li>Inherits JSON deserialization capabilities from {@link AbstractResponse}.</li>
 *     <li>Includes fields for balance details and the associated merchant operation account code.</li>
 *     <li>Supports automatic generation of getters, setters, equals, and hashCode methods through Lombok.</li>
 * </ul>
 *
 * Usage:
 * Use the `fromJson` method provided by {@link AbstractResponse} to deserialize a JSON response into
 * an instance of this class.
 *
 * Example:
 * <pre>
 * String jsonResponse = "{\"balance\": 1500.0, \"merchant_operation_account_code\": \"ACC123456\"}";
 * BalanceResponse response = AbstractResponse.fromJson(jsonResponse, BalanceResponse.class);
 * System.out.println("Balance: " + response.getBalance());
 * System.out.println("Account Code: " + response.getMerchantOperationAccountCode());
 * </pre>
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class BalanceResponse extends AbstractResponse {
    /**
     * The current balance of the operation account.
     */
    private Double balance;

    /**
     * The operation account code associated with the merchant's account.
     */
    private String merchantOperationAccountCode;

    /**
     * Default constructor
     */
    public BalanceResponse() {}
}