package pro.mypvit.responses;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * Represents the response for a Know Your Customer (KYC) inquiry in the MyPVit SDK.
 *
 * <p>This class extends {@link AbstractResponse} to inherit functionality for JSON deserialization
 * and provides specific fields related to KYC information.</p>
 *
 * Key Features:
 * <ul>
 *     <li>Inherits JSON deserialization capabilities from {@link AbstractResponse}.</li>
 *     <li>Includes fields for customer identification and account activity status.</li>
 *     <li>Supports automatic generation of getters, setters, equals, and hashCode methods through Lombok.</li>
 * </ul>
 *
 * Usage:
 * Use the `fromJson` method provided by {@link AbstractResponse} to deserialize a JSON response into
 * an instance of this class.
 *
 * Example:
 * <pre>
 * String jsonResponse = "{"
 *     + "\"full_name\": \"John Doe\","
 *     + "\"customer_account_number\": \"123456789\","
 *     + "\"is_active\": true"
 *     + "}";
 *
 * KycResponse response = AbstractResponse.fromJson(jsonResponse, KycResponse.class);
 * System.out.println("Full Name: " + response.getFullName());
 * System.out.println("Account Number: " + response.getCustomerAccountNumber());
 * System.out.println("Is Active: " + response.isActive());
 * </pre>
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class KycResponse extends AbstractResponse {
    /**
     * The full name of the customer.
     */
    private String fullName;

    /**
     * The account number of the customer.
     */
    private String customerAccountNumber;

    /**
     * Indicates whether the customer's account is active.
     */
    private boolean isActive;

    /**
     * Default constructor
     */
    public KycResponse() {}
}