package pro.mypvit.responses;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * Represents the response for a token generation request in the MyPVit SDK.
 *
 * <p>This class extends {@link AbstractResponse} to inherit functionality for JSON deserialization
 * and provides specific fields related to token generation status.</p>
 *
 * Key Features:
 * <ul>
 *     <li>Inherits JSON deserialization capabilities from {@link AbstractResponse}.</li>
 *     <li>Includes fields for the status code and message returned by the token generation API.</li>
 *     <li>Supports automatic generation of getters, setters, equals, and hashCode methods through Lombok.</li>
 * </ul>
 *
 * Usage:
 * Use the `fromJson` method provided by {@link AbstractResponse} to deserialize a JSON response into
 * an instance of this class.
 *
 * Example:
 * <pre>
 * String jsonResponse = "{"
 *     + "\"status_code\": \"200\","
 *     + "\"message\": \"Token generated successfully\""
 *     + "}";
 *
 * TokenResponse response = AbstractResponse.fromJson(jsonResponse, TokenResponse.class);
 * System.out.println("Status Code: " + response.getStatusCode());
 * System.out.println("Message: " + response.getMessage());
 * </pre>
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class TokenResponse extends AbstractResponse {
    /**
     * The status code returned by the token generation API.
     */
    private String statusCode;

    /**
     * The message returned by the token generation API.
     */
    private String message;

    /**
     * Default constructor
     */
    public TokenResponse() {}
}