/*
 * Decompiled with CFR 0.152.
 */
package pro.nikolaev.restutils.components;

import jakarta.servlet.MultipartConfigElement;
import java.text.MessageFormat;
import org.apache.tomcat.util.http.fileupload.impl.FileSizeLimitExceededException;
import org.apache.tomcat.util.http.fileupload.impl.SizeLimitExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.unit.DataSize;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.resource.NoResourceFoundException;
import pro.nikolaev.restutils.dto.ApiError;
import pro.nikolaev.restutils.exceptions.ApiException;

@RestControllerAdvice
public class ExceptionHandlingAdvice {
    private static final String BAD_REQUEST = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441";
    private final Logger logger = LoggerFactory.getLogger(ExceptionHandlingAdvice.class);
    private final long maxFileSize;
    private final long maxRequestSize;

    public ExceptionHandlingAdvice(MultipartConfigElement multipartConfigElement) {
        this.maxFileSize = DataSize.ofBytes((long)multipartConfigElement.getMaxFileSize()).toMegabytes();
        this.maxRequestSize = DataSize.ofBytes((long)multipartConfigElement.getMaxRequestSize()).toMegabytes();
    }

    @ExceptionHandler(value={ApiException.class})
    public ResponseEntity<ApiError> handleApiException(ApiException e) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)e.getStatus()).header("Connection", new String[]{"Close"})).contentType(MediaType.APPLICATION_JSON).body((Object)new ApiError(e.getReason(), e.getMessage()));
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseEntity<ApiError> handle405(HttpRequestMethodNotSupportedException ignored) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED).header("Connection", new String[]{"Close"})).contentType(MediaType.APPLICATION_JSON).body((Object)new ApiError("\u041c\u0435\u0442\u043e\u0434 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", null));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ApiError> handle400(MethodArgumentNotValidException e) {
        String details = null;
        FieldError fieldError = e.getFieldError();
        ObjectError globalError = e.getGlobalError();
        if (fieldError != null) {
            details = MessageFormat.format("{0} {1}", fieldError.getField(), fieldError.getDefaultMessage());
        } else if (globalError != null) {
            details = MessageFormat.format("{0} {1}", globalError.getObjectName(), globalError.getDefaultMessage());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().header("Connection", new String[]{"Close"})).contentType(MediaType.APPLICATION_JSON).body((Object)new ApiError(BAD_REQUEST, details));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ApiError> handle400(HttpMessageNotReadableException e) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().header("Connection", new String[]{"Close"})).contentType(MediaType.APPLICATION_JSON).body((Object)new ApiError(BAD_REQUEST, e.getMessage()));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<ApiError> handle400(MethodArgumentTypeMismatchException e) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().header("Connection", new String[]{"Close"})).contentType(MediaType.APPLICATION_JSON).body((Object)new ApiError(BAD_REQUEST, MessageFormat.format("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 < {0} >. {1}", e.getParameter().getParameterName(), e.getMessage())));
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ResponseEntity<ApiError> handle406(HttpMediaTypeNotAcceptableException e) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).header("Connection", new String[]{"Close"})).contentType(MediaType.APPLICATION_JSON).body((Object)new ApiError("\u0422\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", e.getMessage()));
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public ResponseEntity<ApiError> handle415(HttpMediaTypeNotSupportedException e) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE).header("Connection", new String[]{"Close"})).contentType(MediaType.APPLICATION_JSON).body((Object)new ApiError("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445", e.getMessage()));
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ResponseEntity<ApiError> handle413(MaxUploadSizeExceededException e) {
        Throwable cause = e.getCause();
        String detail = null;
        if (cause != null) {
            detail = cause.getCause() instanceof SizeLimitExceededException ? MessageFormat.format("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0442\u0435\u043b\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: {0} Mb", this.maxRequestSize) : (cause.getCause() instanceof FileSizeLimitExceededException ? MessageFormat.format("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430: {0} Mb", this.maxFileSize) : MessageFormat.format("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0442\u0435\u043b\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: {0} Mb. \u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u043e\u0434\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430: {1} Mb", this.maxFileSize, this.maxRequestSize));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.PAYLOAD_TOO_LARGE).header("Connection", new String[]{"Close"})).contentType(MediaType.APPLICATION_JSON).body((Object)new ApiError("\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430", detail));
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    public ResponseEntity<ApiError> handleStatusException(ResponseStatusException e) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)e.getStatusCode()).header("Connection", new String[]{"Close"})).contentType(MediaType.APPLICATION_JSON).body((Object)new ApiError(e.getReason(), e.getDetailMessageCode()));
    }

    @ExceptionHandler(value={NoResourceFoundException.class})
    public ResponseEntity<ApiError> handle404(NoResourceFoundException e) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).header("Connection", new String[]{"Close"})).contentType(MediaType.APPLICATION_JSON).body((Object)new ApiError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", e.getResourcePath()));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ApiError> handleUnexpectedException(Exception e) {
        this.logger.error("Unexpected error:", (Throwable)e);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.internalServerError().header("Connection", new String[]{"Close"})).contentType(MediaType.APPLICATION_JSON).body((Object)new ApiError("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f", e.getMessage()));
    }
}

