/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client.awscloudwatch;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import pro.panopticon.client.awscloudwatch.HasCloudwatchConfig;

public class CloudwatchClient {
    private final AmazonCloudWatch cloudFront;
    private HasCloudwatchConfig cloudwatchConfig;

    public CloudwatchClient(HasCloudwatchConfig cloudwatchConfig) {
        this.cloudFront = (AmazonCloudWatch)((AmazonCloudWatchClientBuilder)((AmazonCloudWatchClientBuilder)AmazonCloudWatchClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)cloudwatchConfig))).withRegion(cloudwatchConfig.getRegion())).build();
        this.cloudwatchConfig = cloudwatchConfig;
    }

    public void sendStatistics(List<CloudwatchStatistic> statistics) {
        if (statistics == null || statistics.isEmpty()) {
            return;
        }
        List metricDatumList = statistics.stream().map(CloudwatchStatistic::toMetricsDatum).collect(Collectors.toList());
        PutMetricDataRequest request = new PutMetricDataRequest();
        request.setNamespace(this.cloudwatchConfig.getNamespace());
        request.setMetricData(metricDatumList);
        this.cloudFront.putMetricData(request);
    }

    public static class CloudwatchStatistic {
        private String key;
        private Double value;

        public CloudwatchStatistic(String key, Double value) {
            this.key = key;
            this.value = value;
        }

        public MetricDatum toMetricsDatum() {
            MetricDatum metricDatum = new MetricDatum();
            metricDatum.setMetricName(this.key);
            metricDatum.setTimestamp(new Date());
            metricDatum.setUnit(StandardUnit.Count);
            metricDatum.setValue(this.value);
            return metricDatum;
        }
    }
}

