/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client.util;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemStatus {
    private static final Logger LOG = LoggerFactory.getLogger(SystemStatus.class);
    private static final long DEFAULT_MEM_USAGE = -1L;
    private final Optional<MemoryPoolMXBean> eden;
    private final Optional<MemoryPoolMXBean> survivor;
    private final Optional<MemoryPoolMXBean> old;
    private final OperatingSystemMXBean osBean;
    private final Function<MemoryPoolMXBean, Long> getUsed = memoryPool -> memoryPool.getUsage().getUsed();
    private final Function<MemoryPoolMXBean, Long> getMax = memoryPool -> memoryPool.getUsage().getMax();
    private final Function<MemoryPoolMXBean, Long> getUsedAfterGC = memoryPool -> memoryPool.getCollectionUsage().getUsed();

    public SystemStatus() {
        this.eden = this.findBeanWithName("Eden Space");
        this.survivor = this.findBeanWithName("Survivor Space");
        this.old = this.findBeanWithName("Old Gen", "Tenured", "Tenured Gen");
        this.osBean = ManagementFactory.getOperatingSystemMXBean();
    }

    public long heapUsed() {
        return this.edenUsed() + this.survivorUsed() + this.oldUsed();
    }

    public long heapMax() {
        return this.edenMax() + this.survivorMax() + this.oldMax();
    }

    public long heapAfterGC() {
        return this.edenGC() + this.survivorAfterGC() + this.oldAfterGC();
    }

    public long edenUsed() {
        return this.getMemUsage(this.eden, this.getUsed);
    }

    public long edenMax() {
        return this.getMemUsage(this.eden, this.getMax);
    }

    public long edenGC() {
        return this.getMemUsage(this.eden, this.getUsedAfterGC);
    }

    public long survivorUsed() {
        return this.getMemUsage(this.survivor, this.getUsed);
    }

    public long survivorMax() {
        return this.getMemUsage(this.survivor, this.getMax);
    }

    public long survivorAfterGC() {
        return this.getMemUsage(this.survivor, this.getUsedAfterGC);
    }

    public long oldUsed() {
        return this.getMemUsage(this.old, this.getUsed);
    }

    public long oldMax() {
        return this.getMemUsage(this.old, this.getMax);
    }

    public long oldAfterGC() {
        return this.getMemUsage(this.old, this.getUsedAfterGC);
    }

    public double load() {
        return this.osBean.getSystemLoadAverage();
    }

    public long openFileHandles() {
        if (this.osBean instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)this.osBean).getOpenFileDescriptorCount();
        }
        return -1L;
    }

    public long maxFileHandles() {
        if (this.osBean instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)this.osBean).getMaxFileDescriptorCount();
        }
        return -1L;
    }

    private Optional<MemoryPoolMXBean> findBeanWithName(String ... names) {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPool : memoryPoolMXBeans) {
            for (String name : names) {
                if (!memoryPool.getName().endsWith(name)) continue;
                return Optional.of(memoryPool);
            }
        }
        LOG.error("Could not fetch MemoryPoolMXBean for {}. These beans exists: {}", (Object)Stream.of(names).collect(Collectors.joining(", ")), (Object)memoryPoolMXBeans.stream().map(MemoryPoolMXBean::getName).collect(Collectors.joining(", ")));
        return Optional.empty();
    }

    private long getMemUsage(Optional<MemoryPoolMXBean> mxBean, Function<MemoryPoolMXBean, Long> function) {
        return mxBean.map(function).orElse(-1L);
    }
}

