/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.panopticon.client.model.ComponentInfo;
import pro.panopticon.client.model.Measurement;
import pro.panopticon.client.model.Status;
import pro.panopticon.client.sensor.Sensor;

public class PanopticonClient {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final int TIMEOUT = 10000;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1);
    private final String baseUri;
    private CloseableHttpClient client;

    public PanopticonClient(String baseUri) {
        this.baseUri = baseUri;
        this.client = this.createHttpClient();
    }

    private CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).setConnectionRequestTimeout(10000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    public boolean update(Status status) {
        try {
            String json = OBJECT_MAPPER.writeValueAsString((Object)status);
            String uri = this.baseUri + "/external/status";
            this.LOG.debug("Updating status: " + uri);
            this.LOG.debug("...with JSON: " + json);
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContent((InputStream)new ByteArrayInputStream(json.getBytes()));
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Content-Type", "application/json");
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpPost);
            this.LOG.debug("Response: " + response.getStatusLine().getStatusCode());
            return response.getStatusLine().getStatusCode() < 300;
        }
        catch (IOException e) {
            this.LOG.warn("Error when updating status", (Throwable)e);
            return false;
        }
    }

    public void startScheduledStatusUpdate(ComponentInfo componentInfo, List<Sensor> sensors) {
        Runnable runnable = () -> {
            long before = System.currentTimeMillis();
            List<Measurement> measurements = sensors.parallelStream().map(Sensor::measure).flatMap(Collection::stream).collect(Collectors.toList());
            long afterMeasurements = System.currentTimeMillis();
            boolean success = this.update(new Status(componentInfo, measurements));
            long afterStatusPost = System.currentTimeMillis();
            long measurementTime = afterMeasurements - before;
            long statuspostTime = afterStatusPost - afterMeasurements;
            if (success) {
                this.LOG.info("Sent status update with " + measurements.size() + " measurements. Fetch measurements took " + measurementTime + "ms. Posting status took " + statuspostTime + "ms.");
            } else {
                this.LOG.warn("Could not update status");
            }
        };
        SCHEDULER.scheduleWithFixedDelay(runnable, 0L, 1L, TimeUnit.MINUTES);
    }
}

