/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client.sensor.impl;

import java.util.ArrayList;
import java.util.List;
import pro.panopticon.client.model.Measurement;
import pro.panopticon.client.sensor.Sensor;
import pro.panopticon.client.util.SystemStatus;

public class FileHandlesSensor
implements Sensor {
    private final long warnAfter;
    private final long errorAfter;

    public FileHandlesSensor(long warnAfter, long errorAfter) {
        this.warnAfter = warnAfter;
        this.errorAfter = errorAfter;
    }

    @Override
    public List<Measurement> measure() {
        SystemStatus s = new SystemStatus();
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        long open = s.openFileHandles();
        long max = s.maxFileHandles();
        double percent = (double)open / (double)max * 100.0;
        String displayValue = String.format("%s of %s filehandles used (%.2f%%)", open, max, percent);
        measurements.add(new Measurement("filehandles", this.statusFromOpenFileHandles(open), displayValue, open));
        return measurements;
    }

    private String statusFromOpenFileHandles(long open) {
        if (open >= this.errorAfter) {
            return "ERROR";
        }
        if (open >= this.warnAfter) {
            return "WARN";
        }
        return "INFO";
    }
}

