/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.panopticon.client.awscloudwatch.CloudwatchClient;
import pro.panopticon.client.awscloudwatch.HasCloudwatchConfig;
import pro.panopticon.client.model.ComponentInfo;
import pro.panopticon.client.model.Measurement;
import pro.panopticon.client.model.Status;
import pro.panopticon.client.sensor.Sensor;

public class PanopticonClient {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final int TIMEOUT = 10000;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1);
    private final String baseUri;
    private final HasCloudwatchConfig hasCloudwatchConfig;
    private final CloudwatchClient cloudwatchClient;
    private final CloseableHttpClient client;

    public PanopticonClient(String baseUri, HasCloudwatchConfig hasCloudwatchConfig, CloudwatchClient cloudwatchClient) {
        this.baseUri = baseUri;
        this.hasCloudwatchConfig = hasCloudwatchConfig;
        this.cloudwatchClient = cloudwatchClient;
        this.client = this.createHttpClient();
    }

    public void startScheduledStatusUpdate(ComponentInfo componentInfo, List<Sensor> sensors) {
        SCHEDULER.scheduleWithFixedDelay(() -> this.performSensorCollection(componentInfo, sensors), 0L, 1L, TimeUnit.MINUTES);
    }

    public void shutdownScheduledStatusUpdate() {
        SCHEDULER.shutdown();
    }

    private void performSensorCollection(ComponentInfo componentInfo, List<Sensor> sensors) {
        try {
            long before = System.currentTimeMillis();
            List<Measurement> measurements = this.collectMeasurementsFromSensors(sensors);
            long afterMeasurements = System.currentTimeMillis();
            boolean success = this.sendMeasurementsToPanopticon(new Status(componentInfo, measurements));
            long afterPanopticonPost = System.currentTimeMillis();
            this.sendSelectMeasurementsToCloudwatch(measurements);
            long afterCloudwatchPost = System.currentTimeMillis();
            long measurementTime = afterMeasurements - before;
            long panopticonPostTime = afterPanopticonPost - afterMeasurements;
            long cloudwatchPostTime = afterCloudwatchPost - afterPanopticonPost;
            if (success) {
                this.LOG.info(String.format("Sent status update with %d measurements. Fetch measurements took %dms. Posting status to panopticon took %dms. Posting to cloudwatch took %dms", measurements.size(), measurementTime, panopticonPostTime, cloudwatchPostTime));
            } else {
                this.LOG.warn("Could not update status");
            }
        }
        catch (Exception e) {
            this.LOG.warn("Got error when measuring sensors to send to panopticon", (Throwable)e);
        }
    }

    private List<Measurement> collectMeasurementsFromSensors(List<Sensor> sensors) {
        return sensors.parallelStream().map(sensor -> {
            try {
                return sensor.measure();
            }
            catch (Exception e) {
                this.LOG.warn("Got error running sensor: " + sensor.getClass().getName(), (Throwable)e);
                return new ArrayList();
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean sendMeasurementsToPanopticon(Status status) {
        try {
            String json = OBJECT_MAPPER.writeValueAsString((Object)status);
            String uri = this.baseUri + "/external/status";
            this.LOG.debug("Updating status: " + uri);
            this.LOG.debug("...with JSON: " + json);
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContent((InputStream)new ByteArrayInputStream(json.getBytes()));
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Content-Type", "application/json");
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpPost);){
                this.LOG.debug("Response: " + response.getStatusLine().getStatusCode());
                boolean bl = response.getStatusLine().getStatusCode() < 300;
                return bl;
            }
        }
        catch (IOException e) {
            this.LOG.warn("Error when updating status", (Throwable)e);
            return false;
        }
    }

    private void sendSelectMeasurementsToCloudwatch(List<Measurement> measurements) {
        List<CloudwatchClient.CloudwatchStatistic> statistics = measurements.stream().filter(m -> m.cloudwatchValue != null).map(m -> new CloudwatchClient.CloudwatchStatistic(m.key, m.cloudwatchValue.value, m.cloudwatchValue.unit)).collect(Collectors.toList());
        if (this.cloudwatchClient != null && this.hasCloudwatchConfig != null && this.hasCloudwatchConfig.sensorStatisticsEnabled()) {
            this.cloudwatchClient.sendStatistics(this.hasCloudwatchConfig.sensorStatisticsNamespace(), statistics);
        }
    }

    private CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).setConnectionRequestTimeout(10000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }
}

