/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client.awscloudwatch;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import pro.panopticon.client.awscloudwatch.HasCloudwatchConfig;

public class CloudwatchClient {
    private final AmazonCloudWatch cloudFront;

    public CloudwatchClient(HasCloudwatchConfig cloudwatchConfig) {
        this.cloudFront = (AmazonCloudWatch)((AmazonCloudWatchClientBuilder)((AmazonCloudWatchClientBuilder)AmazonCloudWatchClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)cloudwatchConfig))).withRegion(cloudwatchConfig.getRegion())).build();
    }

    public void sendStatistics(String namespace, List<CloudwatchStatistic> statistics) {
        if (statistics == null || statistics.isEmpty()) {
            return;
        }
        List metricDatumList = statistics.stream().map(CloudwatchStatistic::toMetricsDatum).collect(Collectors.toList());
        PutMetricDataRequest request = new PutMetricDataRequest();
        request.setNamespace(namespace);
        request.setMetricData(metricDatumList);
        this.cloudFront.putMetricData(request);
    }

    public static class CloudwatchStatistic {
        private String key;
        private Double value;
        private StandardUnit unit;

        public CloudwatchStatistic(String key, Double value, StandardUnit unit) {
            this.key = key;
            this.value = value;
            this.unit = unit;
        }

        public CloudwatchStatistic(String key, Double value) {
            this(key, value, StandardUnit.Count);
        }

        public MetricDatum toMetricsDatum() {
            MetricDatum metricDatum = new MetricDatum();
            metricDatum.setMetricName(this.key);
            metricDatum.setTimestamp(new Date());
            metricDatum.setUnit(this.unit);
            metricDatum.setValue(this.value);
            return metricDatum;
        }
    }
}

