/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client.eventlogger;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.panopticon.client.awscloudwatch.CloudwatchClient;
import pro.panopticon.client.awscloudwatch.HasCloudwatchConfig;
import pro.panopticon.client.eventlogger.HasEventInfo;
import pro.panopticon.client.model.Measurement;
import pro.panopticon.client.sensor.Sensor;

public class AbstractEventLogger
implements Sensor {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    ConcurrentMap<String, DoubleAdder> counts = new ConcurrentHashMap<String, DoubleAdder>();
    private HasCloudwatchConfig hasCloudwatchConfig;
    private CloudwatchClient cloudwatchClient;

    public AbstractEventLogger(HasCloudwatchConfig hasCloudwatchConfig, CloudwatchClient cloudwatchClient) {
        this.hasCloudwatchConfig = hasCloudwatchConfig;
        this.cloudwatchClient = cloudwatchClient;
    }

    public void tickAndLog(HasEventInfo event, String ... logappends) {
        this.tickAndLog(event, 1.0, logappends);
    }

    public void tickAndLog(HasEventInfo event, double count, String ... logappends) {
        this.performLog(event, logappends);
        this.performTick(event, count);
    }

    public void tick(HasEventInfo event) {
        this.tick(event, 1.0);
    }

    public void tick(HasEventInfo event, double count) {
        this.performTick(event, count);
    }

    private void performLog(HasEventInfo event, String ... logappends) {
        this.LOG.info("AUDIT EVENT - [" + event.getEventType() + "] - [" + event.getEventName() + "] - " + Stream.of(logappends).map(s -> "[" + s + "]").collect(Collectors.joining(" - ")));
    }

    private void performTick(HasEventInfo event, double count) {
        this.counts.computeIfAbsent(event.getEventName(), s -> new DoubleAdder()).add(count);
    }

    @Override
    public List<Measurement> measure() {
        ConcurrentMap<String, DoubleAdder> mapToProcess = this.counts;
        this.counts = new ConcurrentHashMap<String, DoubleAdder>();
        if (this.cloudwatchClient != null && this.hasCloudwatchConfig != null && this.hasCloudwatchConfig.auditeventStatisticsEnabled()) {
            List<CloudwatchClient.CloudwatchStatistic> statistics = mapToProcess.entrySet().stream().map(e -> new CloudwatchClient.CloudwatchStatistic((String)e.getKey(), ((DoubleAdder)e.getValue()).doubleValue())).collect(Collectors.toList());
            this.cloudwatchClient.sendStatistics(this.hasCloudwatchConfig.auditeventStatisticsNamespace(), statistics);
        }
        return mapToProcess.entrySet().stream().map(e -> new Measurement("audit." + (String)e.getKey(), "INFO", "Last minute: " + ((DoubleAdder)e.getValue()).doubleValue())).collect(Collectors.toList());
    }
}

