/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client.sensor.impl;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.ArrayList;
import java.util.List;
import pro.panopticon.client.model.Measurement;
import pro.panopticon.client.sensor.Sensor;
import pro.panopticon.client.util.SystemStatus;

public class MemorySensor
implements Sensor {
    private static final long BYTES_IN_MB = 0x100000L;

    @Override
    public List<Measurement> measure() {
        SystemStatus s = new SystemStatus();
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        this.putMemoryStatus(measurements, "mem.heap.now", s.heapUsed(), s.heapMax());
        this.putMemoryStatus(measurements, "mem.heap.lastGC", s.heapAfterGC(), s.heapMax());
        return measurements;
    }

    private void putMemoryStatus(List<Measurement> measurements, String key, long used, long max) {
        if (max == 0L || used == -1L) {
            return;
        }
        long percentUsed = used / (max / 100L);
        long percentLeft = 100L - percentUsed;
        String displayValue = this.toMB(used) + " of " + this.toMB(max) + " MB (" + percentUsed + "%)";
        measurements.add(new Measurement(key, this.status(percentLeft), displayValue, new Measurement.CloudwatchValue(percentUsed, StandardUnit.Percent)));
    }

    private String status(long percentLeft) {
        if (percentLeft < 5L) {
            return "ERROR";
        }
        if (percentLeft < 25L) {
            return "WARN";
        }
        return "INFO";
    }

    private long toMB(long bytes) {
        return bytes / 0x100000L;
    }
}

