/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client.awscloudwatch;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.panopticon.client.awscloudwatch.HasCloudwatchConfig;

public class CloudwatchClient {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final AmazonCloudWatch amazonCloudWatch;

    public CloudwatchClient(HasCloudwatchConfig cloudwatchConfig) {
        AmazonCloudWatchClientBuilder clientBuilder = AmazonCloudWatchClientBuilder.standard();
        if (!Strings.isNullOrEmpty((String)cloudwatchConfig.getRegion())) {
            clientBuilder.withRegion(Regions.fromName((String)cloudwatchConfig.getRegion()));
        }
        if (this.credentialsProvided(cloudwatchConfig)) {
            clientBuilder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)cloudwatchConfig));
        }
        this.amazonCloudWatch = (AmazonCloudWatch)clientBuilder.build();
    }

    private boolean credentialsProvided(HasCloudwatchConfig cloudwatchConfig) {
        boolean hasSecretKey;
        boolean hasAccessKey = !Strings.isNullOrEmpty((String)cloudwatchConfig.getAWSAccessKeyId());
        boolean bl = hasSecretKey = !Strings.isNullOrEmpty((String)cloudwatchConfig.getAWSSecretKey());
        if (hasAccessKey != hasSecretKey) {
            throw new IllegalArgumentException("Either Access Key ID or Secret Key is missing. Please provide both, or neither if you want to defer to DefaultAWSCredentialsProviderChain");
        }
        return hasAccessKey;
    }

    public void sendStatistics(String namespace, List<CloudwatchStatistic> statistics) {
        if (statistics == null || statistics.isEmpty()) {
            return;
        }
        long before = System.currentTimeMillis();
        List partitions = Lists.partition(statistics, (int)15);
        partitions.parallelStream().forEach(l -> this.postToCloudwatch(namespace, (List<CloudwatchStatistic>)l));
        long duration = System.currentTimeMillis() - before;
        this.LOG.info(String.format("Sent %d partitions to CloudWatch for namespace %s in %dms", partitions.size(), namespace, duration));
    }

    private void postToCloudwatch(String namespace, List<CloudwatchStatistic> statistics) {
        List metricDatumList = statistics.stream().map(CloudwatchStatistic::toMetricsDatum).collect(Collectors.toList());
        PutMetricDataRequest request = new PutMetricDataRequest();
        request.setNamespace(namespace);
        request.setMetricData(metricDatumList);
        this.amazonCloudWatch.putMetricData(request);
    }

    public static class CloudwatchStatistic {
        private String key;
        private Double value;
        private StandardUnit unit;
        private Date date;

        public CloudwatchStatistic(String key, Double value, StandardUnit unit, Date date) {
            this.key = key;
            this.value = value;
            this.unit = unit;
            this.date = date;
        }

        public CloudwatchStatistic(String key, Double value, StandardUnit unit) {
            this(key, value, unit, new Date());
        }

        public CloudwatchStatistic(String key, Double value) {
            this(key, value, StandardUnit.Count, new Date());
        }

        public MetricDatum toMetricsDatum() {
            MetricDatum metricDatum = new MetricDatum();
            metricDatum.setMetricName(this.key);
            metricDatum.setTimestamp(this.date);
            metricDatum.setUnit(this.unit);
            metricDatum.setValue(this.value);
            return metricDatum;
        }
    }
}

