/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client.responsetimelogger;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import pro.panopticon.client.awscloudwatch.CloudwatchClient;
import pro.panopticon.client.awscloudwatch.HasCloudwatchConfig;
import pro.panopticon.client.model.Measurement;
import pro.panopticon.client.sensor.Sensor;

public class AbstractResponseTimeLogger
implements Sensor {
    private final String namespace;
    private Vector<CloudwatchClient.CloudwatchStatistic> counts = new Vector();
    private CloudwatchClient cloudwatchClient;

    public AbstractResponseTimeLogger(HasCloudwatchConfig hasCloudwatchConfig, CloudwatchClient cloudwatchClient) {
        this.cloudwatchClient = cloudwatchClient;
        this.namespace = String.format("responsetimes-%s-%s", hasCloudwatchConfig.getAppName(), hasCloudwatchConfig.getEnvironment());
    }

    public void addResponseTimeMeasurement(String name, long timeInMilliseconds) {
        this.counts.add(new CloudwatchClient.CloudwatchStatistic(name, Double.valueOf(timeInMilliseconds), StandardUnit.Milliseconds, new Date()));
    }

    @Override
    public List<Measurement> measure() {
        Vector<CloudwatchClient.CloudwatchStatistic> toSubmit = this.counts;
        this.counts = new Vector();
        if (this.cloudwatchClient != null) {
            this.cloudwatchClient.sendStatistics(this.namespace, toSubmit);
        }
        return Collections.emptyList();
    }
}

