/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client.sensor.impl;

import java.time.LocalDateTime;
import java.time.temporal.TemporalAmount;
import java.util.List;
import pro.panopticon.client.model.Measurement;
import pro.panopticon.client.sensor.Sensor;

public abstract class CachedSensor
implements Sensor {
    private TemporalAmount cacheTime;
    private LocalDateTime lastFetchTime;
    private List<Measurement> cachedValue;

    public CachedSensor(TemporalAmount cacheTime) {
        this.cacheTime = cacheTime;
    }

    public abstract List<Measurement> calculateMeasurementsForCaching();

    @Override
    public List<Measurement> measure() {
        if (this.lastFetchTime == null || this.cachedValue == null || this.lastFetchTime.isBefore(LocalDateTime.now().minus(this.cacheTime))) {
            this.cachedValue = this.calculateMeasurementsForCaching();
            this.lastFetchTime = LocalDateTime.now();
        }
        return this.cachedValue;
    }
}

