/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client.sensor.impl;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.ArrayList;
import java.util.List;
import pro.panopticon.client.model.Measurement;
import pro.panopticon.client.sensor.Sensor;
import pro.panopticon.client.util.SystemStatus;

public class MemorySensor
implements Sensor {
    private static final long BYTES_IN_MB = 0x100000L;
    private final int warnLimitNow;
    private final int errorLimitNow;
    private final int warnLimitHeap;
    private final int errorLimitHeap;

    public MemorySensor() {
        this(85, 95, 75, 95);
    }

    public MemorySensor(int warnLimitNow, int errorLimitNow, int warnLimitHeap, int errorLimitHeap) {
        this.warnLimitNow = warnLimitNow;
        this.errorLimitNow = errorLimitNow;
        this.warnLimitHeap = warnLimitHeap;
        this.errorLimitHeap = errorLimitHeap;
    }

    @Override
    public List<Measurement> measure() {
        SystemStatus s = new SystemStatus();
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        this.putMemoryStatus(measurements, "mem.heap.now", s.heapUsed(), s.heapMax(), this.warnLimitNow, this.errorLimitNow);
        this.putMemoryStatus(measurements, "mem.heap.lastGC", s.heapAfterGC(), s.heapMax(), this.warnLimitHeap, this.errorLimitHeap);
        return measurements;
    }

    private void putMemoryStatus(List<Measurement> measurements, String key, long used, long max, int warnLimit, int errorLimit) {
        if (max == 0L || used == -1L) {
            return;
        }
        long percentUsed = used / (max / 100L);
        String displayValue = this.toMB(used) + " of " + this.toMB(max) + " MB (" + percentUsed + "%)";
        measurements.add(new Measurement(key, this.status(percentUsed, warnLimit, errorLimit), displayValue, new Measurement.CloudwatchValue(percentUsed, StandardUnit.Percent)));
    }

    private String status(long percentUsed, int warnLimit, int errorLimit) {
        if (percentUsed > (long)errorLimit) {
            return "ERROR";
        }
        if (percentUsed > (long)warnLimit) {
            return "WARN";
        }
        return "INFO";
    }

    private long toMB(long bytes) {
        return bytes / 0x100000L;
    }
}

