/*
 * Decompiled with CFR 0.152.
 */
package pro.panopticon.client.sensor.impl;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.panopticon.client.model.Measurement;
import pro.panopticon.client.sensor.Sensor;

public class SuccessrateSensor
implements Sensor {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final int numberToKeep;
    private final Double warnLimit;
    private final Double errorLimit;
    private final Map<String, CircularFifoQueue<Event>> eventQueues = new HashMap<String, CircularFifoQueue<Event>>();

    public SuccessrateSensor(int numberToKeep, Double warnLimit, Double errorLimit) {
        this.numberToKeep = numberToKeep;
        this.warnLimit = warnLimit;
        this.errorLimit = errorLimit;
    }

    public synchronized void tickSuccess(String key) {
        try {
            this.getQueueForKey(key).add((Object)Event.SUCCESS);
        }
        catch (Exception e) {
            this.LOG.warn("Something went wrong when counting SUCCESS for " + key, (Throwable)e);
        }
    }

    public synchronized void tickFailure(String key) {
        try {
            this.getQueueForKey(key).add((Object)Event.FAILURE);
        }
        catch (Exception e) {
            this.LOG.warn("Something went wrong when counting FAILURE for " + key, (Throwable)e);
        }
    }

    private CircularFifoQueue<Event> getQueueForKey(String key) {
        return this.eventQueues.computeIfAbsent(key, k -> new CircularFifoQueue(this.numberToKeep));
    }

    @Override
    public List<Measurement> measure() {
        return this.eventQueues.entrySet().stream().map(e -> {
            List events = ((CircularFifoQueue)e.getValue()).stream().collect(Collectors.toList());
            int all = events.size();
            long success = events.stream().filter(a -> a == Event.SUCCESS).count();
            long failure = events.stream().filter(a -> a == Event.FAILURE).count();
            double percentFailureDouble = all > 0 ? (double)failure / (double)all : 0.0;
            boolean enoughDataToAlert = all == this.numberToKeep;
            String display = String.format("Last %s calls: %s success, %s failure (%.2f%% failure)%s", Integer.min(all, this.numberToKeep), success, (long)all - success, percentFailureDouble * 100.0, enoughDataToAlert ? "" : " - not enough calls to report status yet");
            return new Measurement((String)e.getKey(), this.getStatusFromPercentage(enoughDataToAlert, percentFailureDouble), display, new Measurement.CloudwatchValue(percentFailureDouble * 100.0, StandardUnit.Percent));
        }).collect(Collectors.toList());
    }

    private String getStatusFromPercentage(boolean enoughDataToAlert, double percentFailure) {
        if (!enoughDataToAlert) {
            return "INFO";
        }
        if (this.errorLimit != null && percentFailure >= this.errorLimit) {
            return "ERROR";
        }
        if (this.warnLimit != null && percentFailure >= this.warnLimit) {
            return "WARN";
        }
        return "INFO";
    }

    private static enum Event {
        SUCCESS,
        FAILURE;

    }
}

